/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.algorithms.shortestpath;

import java.awt.Color;
import java.util.HashMap;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractShortestPathAlgorithm {
    protected final HashMap<Node, Color> colors;
    protected final HashMap<Node, Double> distances;
    protected final Node sourceNode;
    protected double maxDistance = 0.0;

    public AbstractShortestPathAlgorithm(Node sourceNode) {
        this.sourceNode = sourceNode;
        this.colors = new HashMap();
        this.distances = new HashMap();
    }

    protected boolean relax(Edge edge) {
        Node source = edge.getSource();
        Node target = edge.getTarget();
        double distSource = this.distances.get(source);
        double distTarget = this.distances.get(target);
        double weight = this.edgeWeight(edge);
        double sourceWeight = distSource + weight;
        if (sourceWeight < distTarget) {
            this.distances.put(target, sourceWeight);
            this.maxDistance = Math.max(this.maxDistance, sourceWeight);
            return true;
        }
        return false;
    }

    protected double edgeWeight(Edge edge) {
        return edge.getWeight();
    }

    public abstract void compute();

    public abstract Node getPredecessor(Node var1);

    public abstract Edge getPredecessorIncoming(Node var1);

    public HashMap<Node, Double> getDistances() {
        return this.distances;
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }
}

