/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.algorithms.shortestpath;

import java.util.HashMap;
import java.util.HashSet;
import org.gephi.algorithms.shortestpath.AbstractShortestPathAlgorithm;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.dynamic.DynamicUtilities;
import org.gephi.dynamic.api.DynamicController;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.openide.util.Lookup;

public class DijkstraShortestPathAlgorithm
extends AbstractShortestPathAlgorithm {
    protected final Graph graph;
    protected final HashMap<Node, Edge> predecessors;
    protected TimeInterval timeInterval;

    public DijkstraShortestPathAlgorithm(Graph graph, Node sourceNode) {
        super(sourceNode);
        this.graph = graph;
        this.predecessors = new HashMap();
        DynamicController dynamicController = (DynamicController)Lookup.getDefault().lookup(DynamicController.class);
        if (dynamicController != null) {
            this.timeInterval = DynamicUtilities.getVisibleInterval(dynamicController.getModel(graph.getGraphModel().getWorkspace()));
        }
    }

    public void compute() {
        this.graph.readLock();
        HashSet<Node> nodes = new HashSet<Node>();
        int nodeCount = 0;
        for (Node node : this.graph.getNodes()) {
            this.distances.put(node, Double.POSITIVE_INFINITY);
            nodes.add(node);
            ++nodeCount;
        }
        this.distances.put(this.sourceNode, 0.0);
        while (!nodes.isEmpty()) {
            Double minDistance = Double.POSITIVE_INFINITY;
            Node minDistanceNode = null;
            for (Node k : nodes) {
                Double dist = (Double)this.distances.get(k);
                if (dist.compareTo(minDistance) >= 0) continue;
                minDistance = dist;
                minDistanceNode = k;
            }
            Node currentNode = minDistanceNode;
            nodes.remove(currentNode);
            for (Edge edge : this.graph.getEdges(currentNode)) {
                Node neighbor = this.graph.getOpposite(currentNode, edge);
                double dist = this.edgeWeight(edge) + (Double)this.distances.get(currentNode);
                if (((Double)this.distances.get(neighbor)).equals(Double.POSITIVE_INFINITY)) {
                    this.distances.put(neighbor, dist);
                    this.maxDistance = Math.max(this.maxDistance, dist);
                    this.predecessors.put(neighbor, edge);
                    continue;
                }
                if (!(dist < (Double)this.distances.get(neighbor))) continue;
                this.distances.put(neighbor, dist);
                this.maxDistance = Math.max(this.maxDistance, dist);
                this.predecessors.put(neighbor, edge);
            }
        }
        this.graph.readUnlock();
    }

    protected double edgeWeight(Edge edge) {
        if (this.timeInterval != null) {
            return edge.getWeight(this.timeInterval.getLow(), this.timeInterval.getHigh());
        }
        return edge.getWeight();
    }

    public Node getPredecessor(Node node) {
        Edge edge = this.predecessors.get(node);
        if (edge != null) {
            if (edge.getSource() != node) {
                return edge.getSource();
            }
            return edge.getTarget();
        }
        return null;
    }

    public Edge getPredecessorIncoming(Node node) {
        return this.predecessors.get(node);
    }
}

