/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes;

import org.gephi.data.attributes.AttributeColumnImpl;
import org.gephi.data.attributes.AttributeTableImpl;
import org.gephi.data.attributes.AttributeValueImpl;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeEvent;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.api.AttributeValue;
import org.gephi.data.attributes.event.ValueEvent;

public class AttributeRowImpl
implements AttributeRow {
    protected final Object object;
    protected final AttributeTableImpl attributeTable;
    protected AttributeValueImpl[] values;
    protected int rowVersion = -1;

    public AttributeRowImpl(AttributeTableImpl attributeTable, Object object) {
        this.attributeTable = attributeTable;
        this.object = object;
        this.reset();
    }

    public void reset() {
        this.rowVersion = this.attributeTable.getVersion();
        int attSize = this.attributeTable.countColumns();
        AttributeValueImpl[] newValues = new AttributeValueImpl[attSize];
        for (int i = 0; i < attSize; ++i) {
            newValues[i] = this.attributeTable.getColumn((int)i).defaultValue;
        }
        this.values = newValues;
    }

    public void setValues(AttributeRow attributeRow) {
        if (attributeRow == null) {
            throw new NullPointerException();
        }
        AttributeValue[] attValues = attributeRow.getValues();
        for (int i = 0; i < attValues.length; ++i) {
            this.setValue(attValues[i]);
        }
    }

    public void setValue(int index, Object value) {
        AttributeColumnImpl column = this.attributeTable.getColumn(index);
        if (column == null) {
            throw new IllegalArgumentException("The column doesn't exist");
        }
        this.setValue(column, value);
    }

    public void setValue(String column, Object value) {
        if (column == null) {
            throw new NullPointerException("Column is null");
        }
        AttributeColumnImpl attributeColumn = this.attributeTable.getColumn(column);
        if (attributeColumn != null) {
            this.setValue(attributeColumn, value);
        } else {
            AttributeType type = AttributeType.parse(value);
            if (type != null) {
                attributeColumn = this.attributeTable.addColumn(column, type);
                this.setValue(attributeColumn, value);
            }
        }
    }

    public void setValue(AttributeColumn column, Object value) {
        if (column == null) {
            throw new NullPointerException("Column is null");
        }
        AttributeValue attValue = this.attributeTable.getFactory().newValue(column, value);
        this.setValue(attValue);
    }

    public void setValue(AttributeValue value) {
        AttributeColumn column = value.getColumn();
        if (this.attributeTable.getColumn(column.getIndex()) != column) {
            if ((column = this.attributeTable.getColumn(column)) == null) {
                throw new IllegalArgumentException("The value column doesn't exist");
            }
            value = this.attributeTable.getFactory().newValue(column, value.getValue());
        }
        this.setValue(column.getIndex(), (AttributeValueImpl)value);
    }

    private void setValue(int index, AttributeValueImpl value) {
        this.updateColumns();
        AttributeValueImpl oldValue = this.values[index];
        this.values[index] = value;
        if (!(oldValue == null && value == null || oldValue != null && oldValue.equals(value))) {
            this.attributeTable.model.fireAttributeEvent(new ValueEvent(AttributeEvent.EventType.SET_VALUE, this.attributeTable, this.object, value));
        }
    }

    public Object getValue(AttributeColumn column) {
        AttributeValueImpl val;
        if (column == null) {
            throw new NullPointerException();
        }
        this.updateColumns();
        int index = column.getIndex();
        if (this.checkIndexRange(index) && (val = this.values[index]).getColumn() == column) {
            return val.getValue();
        }
        return null;
    }

    public Object getValue(int index) {
        this.updateColumns();
        if (this.checkIndexRange(index)) {
            AttributeColumnImpl attributeColumn = this.attributeTable.getColumn(index);
            return this.getValue(attributeColumn);
        }
        return null;
    }

    public Object getValue(String column) {
        this.updateColumns();
        AttributeColumnImpl attributeColumn = this.attributeTable.getColumn(column);
        if (attributeColumn != null) {
            return this.getValue(attributeColumn);
        }
        return null;
    }

    public AttributeValue[] getValues() {
        return this.values;
    }

    public AttributeValue getAttributeValueAt(int index) {
        if (this.checkIndexRange(index)) {
            return this.values[index];
        }
        return null;
    }

    public int countValues() {
        this.updateColumns();
        return this.values.length;
    }

    public AttributeColumn getColumnAt(int index) {
        this.updateColumns();
        return this.attributeTable.getColumn(index);
    }

    public Object getObject() {
        return this.object;
    }

    private void updateColumns() {
        int tableVersion = this.attributeTable.getVersion();
        if (this.rowVersion < tableVersion) {
            AttributeColumnImpl[] columns = this.attributeTable.getColumns();
            AttributeValueImpl[] newValues = new AttributeValueImpl[columns.length];
            int j = 0;
            block0: for (int i = 0; i < columns.length; ++i) {
                AttributeColumnImpl tableCol = columns[i];
                newValues[i] = tableCol.defaultValue;
                while (j < this.values.length) {
                    AttributeValueImpl val;
                    if ((val = this.values[j++]).getColumn() != tableCol) continue;
                    newValues[i] = val;
                    continue block0;
                }
            }
            this.values = newValues;
            this.rowVersion = tableVersion;
        }
    }

    private boolean checkIndexRange(int index) {
        return index < this.values.length && index >= 0;
    }

    public int getRowVersion() {
        return this.rowVersion;
    }

    public void setRowVersion(int rowVersion) {
        this.rowVersion = rowVersion;
    }

    public void setValues(AttributeValueImpl[] values) {
        this.values = values;
    }
}

