/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gephi.data.attributes.AbstractAttributeModel;
import org.gephi.data.attributes.AttributeColumnImpl;
import org.gephi.data.attributes.AttributeFactoryImpl;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeEvent;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.event.ColumnEvent;
import org.gephi.data.attributes.spi.AttributeValueDelegateProvider;
import org.gephi.data.attributes.type.TypeConvertor;
import org.gephi.data.properties.PropertiesColumn;

public class AttributeTableImpl
implements AttributeTable {
    protected String name;
    protected final AbstractAttributeModel model;
    protected final List<AttributeColumnImpl> columns = new ArrayList<AttributeColumnImpl>();
    protected final Map<AttributeColumn, AttributeColumn> columnsSet = new HashMap<AttributeColumn, AttributeColumn>();
    protected final Map<String, AttributeColumnImpl> columnsMap = new HashMap<String, AttributeColumnImpl>();
    protected int version = 0;

    public AttributeTableImpl(AbstractAttributeModel model, String name) {
        this.name = name;
        this.model = model;
    }

    public synchronized AttributeColumnImpl[] getColumns() {
        return this.columns.toArray(new AttributeColumnImpl[0]);
    }

    public synchronized int countColumns() {
        return this.columns.size();
    }

    public AttributeColumn addPropertiesColumn(PropertiesColumn propertiesColumn) {
        return this.addColumn(propertiesColumn.getId(), propertiesColumn.getTitle(), propertiesColumn.getType(), propertiesColumn.getOrigin(), propertiesColumn.getDefaultValue());
    }

    public AttributeColumnImpl addColumn(String id, AttributeType type) {
        return this.addColumn(id, id, type, AttributeOrigin.DATA, null, null);
    }

    public AttributeColumnImpl addColumn(String id, AttributeType type, AttributeOrigin origin) {
        return this.addColumn(id, id, type, origin, null, null);
    }

    public AttributeColumnImpl addColumn(String id, String title, AttributeType type, AttributeOrigin origin, Object defaultValue) {
        return this.addColumn(id, title, type, origin, defaultValue, null);
    }

    public AttributeColumn addColumn(String id, String title, AttributeType type, AttributeValueDelegateProvider attributeValueDelegateProvider, Object defaultValue) {
        return this.addColumn(id, title, type, AttributeOrigin.DELEGATE, defaultValue, attributeValueDelegateProvider);
    }

    private synchronized AttributeColumnImpl addColumn(String id, String title, AttributeType type, AttributeOrigin origin, Object defaultValue, AttributeValueDelegateProvider attributeValueDelegateProvider) {
        if (title == null || title.isEmpty() || this.hasColumn(title)) {
            throw new IllegalArgumentException("The title can't be null, empty or already existing in the table");
        }
        if (defaultValue != null) {
            if (defaultValue.getClass() != type.getType()) {
                if (defaultValue.getClass() == String.class) {
                    defaultValue = type.parse((String)defaultValue);
                } else {
                    throw new IllegalArgumentException("The default value type cannot be cast to the type");
                }
            }
            defaultValue = this.model.getManagedValue(defaultValue, type);
        }
        AttributeColumnImpl column = new AttributeColumnImpl(this, this.columns.size(), id, title, type, origin, defaultValue, attributeValueDelegateProvider);
        this.columns.add(column);
        this.columnsMap.put(id, column);
        if (title != null && !title.equals(id)) {
            this.columnsMap.put(title.toLowerCase(), column);
        }
        this.columnsSet.put(column, column);
        ++this.version;
        this.model.fireAttributeEvent(new ColumnEvent(AttributeEvent.EventType.ADD_COLUMN, column));
        return column;
    }

    public synchronized void removeColumn(AttributeColumn column) {
        int index = this.columns.indexOf(column);
        if (index == -1) {
            return;
        }
        ++index;
        while (index < this.columns.size()) {
            AttributeColumnImpl c = this.columns.get(index);
            --c.index;
            ++index;
        }
        this.columns.remove((AttributeColumnImpl)column);
        this.columnsMap.remove(column.getId());
        if (column.getTitle() != null && !column.getTitle().equals(column.getId())) {
            this.columnsMap.remove(column.getTitle());
        }
        this.columnsSet.remove(column);
        this.model.fireAttributeEvent(new ColumnEvent(AttributeEvent.EventType.REMOVE_COLUMN, (AttributeColumnImpl)column));
        ++this.version;
    }

    public synchronized AttributeColumn replaceColumn(AttributeColumn source, AttributeColumnImpl targetImpl) {
        int index = this.columns.indexOf(source);
        if (index == -1) {
            return null;
        }
        this.columnsMap.remove(source.getId());
        if (source.getTitle() != null && !source.getTitle().equals(source.getId())) {
            this.columnsMap.remove(source.getTitle());
        }
        this.columnsSet.remove(source);
        targetImpl.index = index;
        this.columns.set(index, targetImpl);
        this.columnsMap.put(targetImpl.id, targetImpl);
        if (targetImpl.title != null && !targetImpl.title.equals(targetImpl.id)) {
            this.columnsMap.put(targetImpl.title.toLowerCase(), targetImpl);
        }
        this.columnsSet.put(targetImpl, targetImpl);
        ++this.version;
        return targetImpl;
    }

    public synchronized AttributeColumn replaceColumn(AttributeColumn source, String id, String title, AttributeType type, AttributeOrigin origin, Object defaultValue) {
        if (defaultValue != null) {
            if (defaultValue.getClass() != type.getType()) {
                if (defaultValue.getClass() == String.class) {
                    defaultValue = type.parse((String)defaultValue);
                } else {
                    throw new IllegalArgumentException("The default value type cannot be cast to the type");
                }
            }
            defaultValue = this.model.getManagedValue(defaultValue, type);
        }
        AttributeColumnImpl targetImpl = new AttributeColumnImpl(this, this.columns.size(), id, title, type, origin, defaultValue, null);
        return this.replaceColumn(source, targetImpl);
    }

    public synchronized AttributeColumnImpl getColumn(int index) {
        if (index >= 0 && index < this.columns.size()) {
            return this.columns.get(index);
        }
        return null;
    }

    public synchronized AttributeColumnImpl getColumn(String id) {
        AttributeColumnImpl col = this.columnsMap.get(id);
        if (col == null) {
            return this.columnsMap.get(id.toLowerCase());
        }
        return col;
    }

    public synchronized AttributeColumnImpl getColumn(String title, AttributeType type) {
        AttributeColumnImpl c = this.columnsMap.get(title.toLowerCase());
        if (c != null && c.getType().equals((Object)type)) {
            return c;
        }
        return null;
    }

    public synchronized AttributeColumn getColumn(AttributeColumn column) {
        return this.columnsSet.get(column);
    }

    public synchronized boolean hasColumn(String title) {
        return this.columnsMap.containsKey(title) || this.columnsMap.containsKey(title.toLowerCase());
    }

    public synchronized int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AttributeFactoryImpl getFactory() {
        return this.model.getFactory();
    }

    public AbstractAttributeModel getModel() {
        return this.model;
    }

    public synchronized void mergeTable(AttributeTable table) {
        for (AttributeColumn column : table.getColumns()) {
            AttributeColumn existingCol = this.getColumn(column);
            if (existingCol == null) {
                existingCol = this.getColumn(column.getTitle());
            }
            if (existingCol == null) {
                this.addColumn(column.getId(), column.getTitle(), column.getType(), column.getOrigin(), column.getDefaultValue());
                continue;
            }
            if (!column.getType().isDynamicType() || !TypeConvertor.getStaticType(column.getType()).equals((Object)existingCol.getType())) continue;
            AttributeColumnImpl newCol = new AttributeColumnImpl(this, existingCol.getIndex(), existingCol.getId(), existingCol.getTitle(), column.getType(), existingCol.getOrigin(), column.getDefaultValue(), null);
            this.replaceColumn(existingCol, newCol);
        }
    }
}

