/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.api;

import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public abstract class AttributeUtils {
    public abstract boolean isNodeColumn(AttributeColumn var1);

    public abstract boolean isEdgeColumn(AttributeColumn var1);

    public abstract boolean isColumnOfType(AttributeColumn var1, AttributeType var2);

    public abstract boolean areAllColumnsOfType(AttributeColumn[] var1, AttributeType var2);

    public abstract boolean areAllColumnsOfSameType(AttributeColumn[] var1);

    public abstract boolean isStringColumn(AttributeColumn var1);

    public abstract boolean areAllStringColumns(AttributeColumn[] var1);

    public abstract boolean isNumberColumn(AttributeColumn var1);

    public abstract boolean areAllNumberColumns(AttributeColumn[] var1);

    public abstract boolean isNumberListColumn(AttributeColumn var1);

    public abstract boolean areAllNumberListColumns(AttributeColumn[] var1);

    public abstract boolean isNumberOrNumberListColumn(AttributeColumn var1);

    public abstract boolean areAllNumberOrNumberListColumns(AttributeColumn[] var1);

    public abstract boolean isDynamicNumberColumn(AttributeColumn var1);

    public abstract boolean areAllDynamicNumberColumns(AttributeColumn[] var1);

    public abstract AttributeColumn[] getNumberColumns(AttributeTable var1);

    public abstract AttributeColumn[] getStringColumns(AttributeTable var1);

    public abstract Comparable getMin(AttributeColumn var1, Comparable[] var2);

    public abstract Comparable getMax(AttributeColumn var1, Comparable[] var2);

    public static synchronized AttributeUtils getDefault() {
        return (AttributeUtils)Lookup.getDefault().lookup(AttributeUtils.class);
    }

    public static String getXMLDateStringFromDouble(double d) {
        try {
            DatatypeFactory dateFactory = DatatypeFactory.newInstance();
            if (d == Double.NEGATIVE_INFINITY) {
                return "-Infinity";
            }
            if (d == Double.POSITIVE_INFINITY) {
                return "Infinity";
            }
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTimeInMillis((long)d);
            return dateFactory.newXMLGregorianCalendar(gc).toXMLFormat().substring(0, 23);
        }
        catch (DatatypeConfigurationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return "";
        }
    }
}

