/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.gephi.data.attributes.AbstractAttributeModel;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeEvent;
import org.gephi.data.attributes.api.AttributeListener;
import org.gephi.data.attributes.api.AttributeValue;
import org.gephi.data.attributes.event.AbstractEvent;
import org.gephi.data.attributes.event.AttributeEventDataImpl;
import org.gephi.data.attributes.event.AttributeEventImpl;
import org.gephi.data.attributes.event.ColumnEvent;
import org.gephi.data.attributes.event.ValueEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeEventManager
implements Runnable {
    private static final long DELAY = 1L;
    private final AbstractAttributeModel model;
    private final List<AttributeListener> listeners;
    private final AtomicReference<Thread> thread = new AtomicReference();
    private final LinkedBlockingQueue<AbstractEvent> eventQueue;
    private final Object lock = new Object();
    private boolean stop;

    public AttributeEventManager(AbstractAttributeModel model) {
        this.model = model;
        this.eventQueue = new LinkedBlockingQueue();
        this.listeners = Collections.synchronizedList(new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stop) {
            Object event;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            ArrayList eventCompress = null;
            ArrayList<Object> eventCompressObjects = null;
            AbstractEvent precEvt = null;
            AbstractEvent evt = null;
            while ((evt = this.eventQueue.peek()) != null) {
                if (precEvt != null) {
                    if (!(evt instanceof ValueEvent) && !(evt instanceof ColumnEvent) || !precEvt.getEventType().equals((Object)evt.getEventType()) || precEvt.getAttributeTable() != evt.getAttributeTable()) break;
                    if (eventCompress == null) {
                        eventCompress = new ArrayList();
                        eventCompress.add(precEvt.getData());
                    }
                    if (evt instanceof ValueEvent) {
                        if (eventCompressObjects == null) {
                            eventCompressObjects = new ArrayList<Object>();
                            eventCompressObjects.add(((ValueEvent)precEvt).getObject());
                        }
                        eventCompressObjects.add(((ValueEvent)evt).getObject());
                    }
                    eventCompress.add(evt.getData());
                }
                this.eventQueue.poll();
                precEvt = evt;
            }
            if (precEvt != null) {
                event = this.createEvent(precEvt, eventCompress, eventCompressObjects);
                for (AttributeListener l : this.listeners.toArray(new AttributeListener[0])) {
                    l.attributesChanged((AttributeEvent)event);
                }
            }
            while (this.eventQueue.isEmpty()) {
                try {
                    event = this.lock;
                    synchronized (event) {
                        this.lock.wait();
                    }
                }
                catch (InterruptedException e) {
                }
            }
        }
    }

    private AttributeEvent createEvent(AbstractEvent event, List<Object> compress, List<Object> compressObjects) {
        AttributeEventDataImpl eventData = new AttributeEventDataImpl();
        AttributeEventImpl attributeEvent = new AttributeEventImpl(event.getEventType(), event.getAttributeTable(), eventData);
        if (event instanceof ValueEvent) {
            Object[] objects;
            AttributeValue[] values;
            if (compress != null) {
                values = compress.toArray(new AttributeValue[0]);
                objects = compressObjects.toArray();
            } else {
                values = new AttributeValue[]{(AttributeValue)event.getData()};
                objects = new Object[]{((ValueEvent)event).getObject()};
            }
            eventData.setValues(values);
            eventData.setObjects(objects);
        } else if (event instanceof ColumnEvent) {
            AttributeColumn[] columns = compress != null ? compress.toArray(new AttributeColumn[0]) : new AttributeColumn[]{(AttributeColumn)event.getData()};
            eventData.setColumns(columns);
        }
        return attributeEvent;
    }

    public void stop(boolean stop) {
        this.stop = stop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(AbstractEvent event) {
        this.eventQueue.add(event);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public void start() {
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.setName("attribute-event-bus");
        if (this.thread.compareAndSet(null, t)) {
            t.start();
        }
    }

    public boolean isRunning() {
        return this.thread.get() != null;
    }

    public void addAttributeListener(AttributeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeAttributeListener(AttributeListener listener) {
        this.listeners.remove(listener);
    }
}

