/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.serialization;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gephi.data.attributes.AbstractAttributeModel;
import org.gephi.data.attributes.AttributeColumnImpl;
import org.gephi.data.attributes.AttributeTableImpl;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeType;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AttributeModelSerializer {
    private static final String ELEMENT_MODEL = "attributemodel";
    private static final String ELEMENT_TABLE = "table";
    private static final String ELEMENT_COLUMN = "column";
    private static final String ELEMENT_COLUMN_INDEX = "index";
    private static final String ELEMENT_COLUMN_ID = "id";
    private static final String ELEMENT_COLUMN_TITLE = "title";
    private static final String ELEMENT_COLUMN_TYPE = "type";
    private static final String ELEMENT_COLUMN_ORIGIN = "origin";
    private static final String ELEMENT_COLUMN_DEFAULT = "default";

    public Document createDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            document.setXmlVersion("1.0");
            document.setXmlStandalone(true);
            return document;
        }
        catch (ParserConfigurationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public Element writeModel(Document document, AbstractAttributeModel model) {
        Element modelE = document.createElement(ELEMENT_MODEL);
        if (model != null) {
            for (AttributeTableImpl table : model.getTables()) {
                Element tableE = this.writeTable(document, table);
                tableE.setAttribute("nodetable", String.valueOf(table == model.getNodeTable()));
                tableE.setAttribute("edgetable", String.valueOf(table == model.getEdgeTable()));
                modelE.appendChild(tableE);
            }
        }
        return modelE;
    }

    public void readModel(Element modelE, AbstractAttributeModel model) {
        NodeList modelListE = modelE.getChildNodes();
        for (int i = 0; i < modelListE.getLength(); ++i) {
            Element itemE;
            if (modelListE.item(i).getNodeType() != 1 || !(itemE = (Element)modelListE.item(i)).getTagName().equals(ELEMENT_TABLE)) continue;
            AttributeTableImpl table = Boolean.parseBoolean(itemE.getAttribute("nodetable")) ? model.getNodeTable() : (Boolean.parseBoolean(itemE.getAttribute("edgetable")) ? model.getEdgeTable() : new AttributeTableImpl(model, ""));
            this.readTable(itemE, table);
            if (table == model.getNodeTable() || table == model.getEdgeTable()) continue;
            model.addTable(table);
        }
    }

    public Element writeTable(Document document, AttributeTableImpl table) {
        Element tableE = document.createElement(ELEMENT_TABLE);
        tableE.setAttribute("name", table.getName());
        tableE.setAttribute("version", String.valueOf(table.getVersion()));
        for (AttributeColumnImpl columnImpl : table.getColumns()) {
            Element columnE = this.writeColumn(document, columnImpl);
            tableE.appendChild(columnE);
        }
        return tableE;
    }

    public void readTable(Element tableE, AttributeTableImpl table) {
        table.setName(tableE.getAttribute("name"));
        NodeList tableListE = tableE.getChildNodes();
        for (int i = 0; i < tableListE.getLength(); ++i) {
            Element itemE;
            if (tableListE.item(i).getNodeType() != 1 || !(itemE = (Element)tableListE.item(i)).getTagName().equals(ELEMENT_COLUMN)) continue;
            this.readColumn(itemE, table);
        }
        table.setVersion(Integer.parseInt(tableE.getAttribute("version")));
    }

    public Element writeColumn(Document document, AttributeColumnImpl column) {
        Element columnE = document.createElement(ELEMENT_COLUMN);
        Element indexE = document.createElement(ELEMENT_COLUMN_INDEX);
        indexE.setTextContent(String.valueOf(column.getIndex()));
        columnE.appendChild(indexE);
        Element idE = document.createElement(ELEMENT_COLUMN_ID);
        idE.setTextContent(String.valueOf(column.getId()));
        columnE.appendChild(idE);
        Element titleE = document.createElement(ELEMENT_COLUMN_TITLE);
        titleE.setTextContent(String.valueOf(column.getTitle()));
        columnE.appendChild(titleE);
        Element typeE = document.createElement(ELEMENT_COLUMN_TYPE);
        typeE.setTextContent(column.getType().getTypeString());
        columnE.appendChild(typeE);
        Element origineE = document.createElement(ELEMENT_COLUMN_ORIGIN);
        origineE.setTextContent(column.getOrigin().name());
        columnE.appendChild(origineE);
        Element defaultE = document.createElement(ELEMENT_COLUMN_DEFAULT);
        if (column.getDefaultValue() != null) {
            defaultE.setTextContent(column.getDefaultValue().toString());
        }
        columnE.appendChild(defaultE);
        return columnE;
    }

    public void readColumn(Element columnE, AttributeTableImpl table) {
        int index = 0;
        String id = "";
        String title = "";
        AttributeType type = AttributeType.STRING;
        AttributeOrigin origin = AttributeOrigin.DATA;
        Object defaultValue = null;
        NodeList columnListE = columnE.getChildNodes();
        for (int i = 0; i < columnListE.getLength(); ++i) {
            if (columnListE.item(i).getNodeType() != 1) continue;
            Element itemE = (Element)columnListE.item(i);
            if (itemE.getTagName().equals(ELEMENT_COLUMN_INDEX)) {
                index = Integer.parseInt(itemE.getTextContent());
                continue;
            }
            if (itemE.getTagName().equals(ELEMENT_COLUMN_ID)) {
                id = itemE.getTextContent();
                continue;
            }
            if (itemE.getTagName().equals(ELEMENT_COLUMN_TITLE)) {
                title = itemE.getTextContent();
                continue;
            }
            if (itemE.getTagName().equals(ELEMENT_COLUMN_TYPE)) {
                type = AttributeType.valueOf(itemE.getTextContent());
                continue;
            }
            if (itemE.getTagName().equals(ELEMENT_COLUMN_ORIGIN)) {
                origin = AttributeOrigin.valueOf(itemE.getTextContent());
                continue;
            }
            if (!itemE.getTagName().equals(ELEMENT_COLUMN_DEFAULT) || itemE.getTextContent().isEmpty()) continue;
            defaultValue = type.parse(itemE.getTextContent());
        }
        if (!table.hasColumn(title)) {
            table.addColumn(id, title, type, origin, defaultValue);
        } else {
            table.replaceColumn(table.getColumn(title), id, title, type, origin, defaultValue);
        }
    }
}

