/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.serialization;

import org.gephi.data.attributes.AbstractAttributeModel;
import org.gephi.data.attributes.AttributeColumnImpl;
import org.gephi.data.attributes.AttributeRowImpl;
import org.gephi.data.attributes.AttributeTableImpl;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.api.AttributeValue;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AttributeRowSerializer {
    private static final String ELEMENT_ROWS = "attributerows";
    private static final String ELEMENT_NODE_ROW = "noderow";
    private static final String ELEMENT_EDGE_ROW = "edgerow";
    private static final String ELEMENT_VALUE = "attvalue";

    public Element writeRows(Document document, GraphModel graphModel) {
        Element rowsE = document.createElement(ELEMENT_ROWS);
        HierarchicalGraph hierarchicalGraph = graphModel.getHierarchicalGraph();
        for (Node node : hierarchicalGraph.getNodesTree()) {
            if (node.getNodeData().getAttributes() == null || !(node.getNodeData().getAttributes() instanceof AttributeRowImpl)) continue;
            AttributeRowImpl row = (AttributeRowImpl)node.getNodeData().getAttributes();
            Element rowE = document.createElement(ELEMENT_NODE_ROW);
            rowE.setAttribute("for", String.valueOf(node.getId()));
            if (!this.writeRow(document, rowE, row)) continue;
            rowsE.appendChild(rowE);
        }
        for (Node node : hierarchicalGraph.getNodesTree()) {
            for (Edge edge : hierarchicalGraph.getEdges(node)) {
                if (edge.getEdgeData().getAttributes() == null || !(edge.getEdgeData().getAttributes() instanceof AttributeRowImpl)) continue;
                AttributeRowImpl row = (AttributeRowImpl)edge.getEdgeData().getAttributes();
                Element rowE = document.createElement(ELEMENT_EDGE_ROW);
                rowE.setAttribute("for", String.valueOf(edge.getId()));
                if (!this.writeRow(document, rowE, row)) continue;
                rowsE.appendChild(rowE);
            }
        }
        return rowsE;
    }

    public void readRows(Element rowsE, GraphModel graphModel, AbstractAttributeModel attributeModel) {
        HierarchicalGraph hierarchicalGraph = graphModel.getHierarchicalGraph();
        NodeList rowList = rowsE.getChildNodes();
        for (int i = 0; i < rowList.getLength(); ++i) {
            Edge edge;
            AttributeRowImpl row;
            int id;
            if (rowList.item(i).getNodeType() != 1) continue;
            Element itemE = (Element)rowList.item(i);
            if (itemE.getTagName().equals(ELEMENT_NODE_ROW)) {
                id = Integer.parseInt(itemE.getAttribute("for"));
                Node node = hierarchicalGraph.getNode(id);
                if (node.getNodeData().getAttributes() == null || !(node.getNodeData().getAttributes() instanceof AttributeRowImpl)) continue;
                row = (AttributeRowImpl)node.getNodeData().getAttributes();
                this.readRow(itemE, attributeModel, attributeModel.getNodeTable(), row);
                continue;
            }
            if (!itemE.getTagName().equals(ELEMENT_EDGE_ROW) || (edge = hierarchicalGraph.getEdge(id = Integer.parseInt(itemE.getAttribute("for")))).getEdgeData().getAttributes() == null || !(edge.getEdgeData().getAttributes() instanceof AttributeRowImpl)) continue;
            row = (AttributeRowImpl)edge.getEdgeData().getAttributes();
            this.readRow(itemE, attributeModel, attributeModel.getEdgeTable(), row);
        }
    }

    public boolean writeRow(Document document, Element rowE, AttributeRowImpl row) {
        rowE.setAttribute("version", String.valueOf(row.getRowVersion()));
        int writtenRows = 0;
        for (AttributeValue value : row.getValues()) {
            int index = value.getColumn().getIndex();
            Object obj = value.getValue();
            if (obj == null) continue;
            ++writtenRows;
            Element valueE = document.createElement(ELEMENT_VALUE);
            valueE.setAttribute("index", String.valueOf(index));
            valueE.setTextContent(obj.toString());
            rowE.appendChild(valueE);
        }
        return writtenRows > 0;
    }

    public void readRow(Element rowE, AbstractAttributeModel model, AttributeTableImpl table, AttributeRowImpl row) {
        NodeList rowList = rowE.getChildNodes();
        for (int i = 0; i < rowList.getLength(); ++i) {
            Element itemE;
            if (rowList.item(i).getNodeType() != 1 || !(itemE = (Element)rowList.item(i)).getTagName().equals(ELEMENT_VALUE)) continue;
            AttributeColumnImpl col = table.getColumn(Integer.parseInt(itemE.getAttribute("index")));
            AttributeType type = col.getType();
            Object value = type.parse(itemE.getTextContent());
            value = model.getManagedValue(value, type);
            row.setValue(col, value);
        }
        row.setRowVersion(Integer.parseInt(rowE.getAttribute("version")));
    }
}

