/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.type;

import java.util.Arrays;
import org.gephi.data.attributes.type.TypeConvertor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractList<T> {
    public static final String DEFAULT_SEPARATOR = ",|;";
    protected final T[] list;
    private volatile int hashCode = 0;

    public AbstractList(String input, Class<T> finalType) {
        this(input, DEFAULT_SEPARATOR, finalType);
    }

    public AbstractList(String input, String separator, Class<T> finalType) {
        this(TypeConvertor.createArrayFromString(input, separator, finalType));
    }

    public AbstractList(T[] array) {
        this.list = Arrays.copyOf(array, array.length);
    }

    public int size() {
        return this.list.length;
    }

    public T getItem(int index) {
        if (index >= this.list.length) {
            return null;
        }
        return this.list[index];
    }

    public boolean contains(T value) {
        for (int i = 0; i < this.list.length; ++i) {
            if (!this.list[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.list.length; ++i) {
            builder.append(this.list[i]);
            builder.append(',');
        }
        if (this.list.length > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractList)) {
            return false;
        }
        AbstractList s = (AbstractList)obj;
        if (s.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.list.length; ++i) {
            if (this.getItem(i) == s.getItem(i)) continue;
            if (this.getItem(i) != null && !this.getItem(i).equals(s.getItem(i))) {
                return false;
            }
            if (s.getItem(i) == null || s.getItem(i).equals(this.getItem(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = 7;
            for (int i = 0; i < this.list.length; ++i) {
                hash = 53 * hash + (this.list[i] != null ? this.list[i].hashCode() : 0);
            }
            this.hashCode = hash;
        }
        return this.hashCode;
    }
}

