/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.type;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Hashtable;
import java.util.List;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.Interval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DynamicBigDecimal
extends DynamicType<BigDecimal> {
    public DynamicBigDecimal() {
    }

    public DynamicBigDecimal(Interval<BigDecimal> in) {
        super(in);
    }

    public DynamicBigDecimal(List<Interval<BigDecimal>> in) {
        super(in);
    }

    public DynamicBigDecimal(DynamicBigDecimal source) {
        super(source);
    }

    public DynamicBigDecimal(DynamicBigDecimal source, Interval<BigDecimal> in) {
        super(source, in);
    }

    public DynamicBigDecimal(DynamicBigDecimal source, Interval<BigDecimal> in, Interval<BigDecimal> out) {
        super(source, in, out);
    }

    public DynamicBigDecimal(DynamicBigDecimal source, List<Interval<BigDecimal>> in) {
        super(source, in);
    }

    public DynamicBigDecimal(DynamicBigDecimal source, List<Interval<BigDecimal>> in, List<Interval<BigDecimal>> out) {
        super(source, in, out);
    }

    @Override
    public BigDecimal getValue(Interval interval, Estimator estimator) {
        List values = this.getValues(interval);
        if (values.isEmpty()) {
            return null;
        }
        switch (estimator) {
            case AVERAGE: {
                if (values.size() == 1) {
                    return (BigDecimal)values.get(0);
                }
                BigDecimal total = new BigDecimal(0);
                for (int i = 0; i < values.size(); ++i) {
                    total = total.add((BigDecimal)values.get(i));
                }
                return total.divide(BigDecimal.valueOf(values.size()), RoundingMode.HALF_UP);
            }
            case MEDIAN: {
                if (values.size() % 2 == 1) {
                    return (BigDecimal)values.get(values.size() / 2);
                }
                BigDecimal bd = (BigDecimal)values.get(values.size() / 2 - 1);
                bd = bd.add((BigDecimal)values.get(values.size() / 2));
                return bd.divide(new BigDecimal(2));
            }
            case MODE: {
                Hashtable<Integer, Integer> map = new Hashtable<Integer, Integer>();
                for (int i = 0; i < values.size(); ++i) {
                    int prev = 0;
                    if (map.containsKey(((BigDecimal)values.get(i)).hashCode())) {
                        prev = (Integer)map.get(((BigDecimal)values.get(i)).hashCode());
                    }
                    map.put(((BigDecimal)values.get(i)).hashCode(), prev + 1);
                }
                int max = (Integer)map.get(((BigDecimal)values.get(0)).hashCode());
                int index = 0;
                for (int i = 1; i < values.size(); ++i) {
                    if (max >= (Integer)map.get(((BigDecimal)values.get(i)).hashCode())) continue;
                    max = (Integer)map.get(((BigDecimal)values.get(i)).hashCode());
                    index = i;
                }
                return (BigDecimal)values.get(index);
            }
            case SUM: {
                BigDecimal sum = new BigDecimal(0);
                for (int i = 0; i < values.size(); ++i) {
                    sum = sum.add((BigDecimal)values.get(i));
                }
                return sum;
            }
            case MIN: {
                BigDecimal minimum = (BigDecimal)values.get(0);
                for (int i = 1; i < values.size(); ++i) {
                    if (minimum.compareTo((BigDecimal)values.get(i)) <= 0) continue;
                    minimum = (BigDecimal)values.get(i);
                }
                return minimum;
            }
            case MAX: {
                BigDecimal maximum = (BigDecimal)values.get(0);
                for (int i = 1; i < values.size(); ++i) {
                    if (maximum.compareTo((BigDecimal)values.get(i)) >= 0) continue;
                    maximum = (BigDecimal)values.get(i);
                }
                return maximum;
            }
            case FIRST: {
                return (BigDecimal)values.get(0);
            }
            case LAST: {
                return (BigDecimal)values.get(values.size() - 1);
            }
        }
        throw new IllegalArgumentException("Unknown estimator.");
    }

    @Override
    public Class getUnderlyingType() {
        return BigDecimal.class;
    }
}

