/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.type;

import java.math.BigInteger;
import java.util.Hashtable;
import java.util.List;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.Interval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DynamicBigInteger
extends DynamicType<BigInteger> {
    public DynamicBigInteger() {
    }

    public DynamicBigInteger(Interval<BigInteger> in) {
        super(in);
    }

    public DynamicBigInteger(List<Interval<BigInteger>> in) {
        super(in);
    }

    public DynamicBigInteger(DynamicBigInteger source) {
        super(source);
    }

    public DynamicBigInteger(DynamicBigInteger source, Interval<BigInteger> in) {
        super(source, in);
    }

    public DynamicBigInteger(DynamicBigInteger source, Interval<BigInteger> in, Interval<BigInteger> out) {
        super(source, in, out);
    }

    public DynamicBigInteger(DynamicBigInteger source, List<Interval<BigInteger>> in) {
        super(source, in);
    }

    public DynamicBigInteger(DynamicBigInteger source, List<Interval<BigInteger>> in, List<Interval<BigInteger>> out) {
        super(source, in, out);
    }

    @Override
    public BigInteger getValue(Interval interval, Estimator estimator) {
        List values = this.getValues(interval);
        if (values.isEmpty()) {
            return null;
        }
        switch (estimator) {
            case AVERAGE: {
                if (values.size() == 1) {
                    return (BigInteger)values.get(0);
                }
                BigInteger total = BigInteger.valueOf(0L);
                for (int i = 0; i < values.size(); ++i) {
                    total = total.add((BigInteger)values.get(i));
                }
                return total.divide(BigInteger.valueOf(values.size()));
            }
            case MEDIAN: {
                if (values.size() % 2 == 1) {
                    return (BigInteger)values.get(values.size() / 2);
                }
                BigInteger bi = (BigInteger)values.get(values.size() / 2 - 1);
                bi = bi.add((BigInteger)values.get(values.size() / 2));
                return bi.divide(BigInteger.valueOf(2L));
            }
            case MODE: {
                Hashtable<Integer, Integer> map = new Hashtable<Integer, Integer>();
                for (int i = 0; i < values.size(); ++i) {
                    int prev = 0;
                    if (map.containsKey(((BigInteger)values.get(i)).hashCode())) {
                        prev = (Integer)map.get(((BigInteger)values.get(i)).hashCode());
                    }
                    map.put(((BigInteger)values.get(i)).hashCode(), prev + 1);
                }
                int max = (Integer)map.get(((BigInteger)values.get(0)).hashCode());
                int index = 0;
                for (int i = 1; i < values.size(); ++i) {
                    if (max >= (Integer)map.get(((BigInteger)values.get(i)).hashCode())) continue;
                    max = (Integer)map.get(((BigInteger)values.get(i)).hashCode());
                    index = i;
                }
                return (BigInteger)values.get(index);
            }
            case SUM: {
                BigInteger sum = BigInteger.valueOf(0L);
                for (int i = 0; i < values.size(); ++i) {
                    sum = sum.add((BigInteger)values.get(i));
                }
                return sum;
            }
            case MIN: {
                BigInteger minimum = (BigInteger)values.get(0);
                for (int i = 1; i < values.size(); ++i) {
                    if (minimum.compareTo((BigInteger)values.get(i)) <= 0) continue;
                    minimum = (BigInteger)values.get(i);
                }
                return minimum;
            }
            case MAX: {
                BigInteger maximum = (BigInteger)values.get(0);
                for (int i = 1; i < values.size(); ++i) {
                    if (maximum.compareTo((BigInteger)values.get(i)) >= 0) continue;
                    maximum = (BigInteger)values.get(i);
                }
                return maximum;
            }
            case FIRST: {
                return (BigInteger)values.get(0);
            }
            case LAST: {
                return (BigInteger)values.get(values.size() - 1);
            }
        }
        throw new IllegalArgumentException("Unknown estimator.");
    }

    @Override
    public Class getUnderlyingType() {
        return BigInteger.class;
    }
}

