/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.type;

import java.util.Hashtable;
import java.util.List;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.Interval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DynamicCharacter
extends DynamicType<Character> {
    public DynamicCharacter() {
    }

    public DynamicCharacter(Interval<Character> in) {
        super(in);
    }

    public DynamicCharacter(List<Interval<Character>> in) {
        super(in);
    }

    public DynamicCharacter(DynamicCharacter source) {
        super(source);
    }

    public DynamicCharacter(DynamicCharacter source, Interval<Character> in) {
        super(source, in);
    }

    public DynamicCharacter(DynamicCharacter source, Interval<Character> in, Interval<Character> out) {
        super(source, in, out);
    }

    public DynamicCharacter(DynamicCharacter source, List<Interval<Character>> in) {
        super(source, in);
    }

    public DynamicCharacter(DynamicCharacter source, List<Interval<Character>> in, List<Interval<Character>> out) {
        super(source, in, out);
    }

    @Override
    public Character getValue(Interval interval, Estimator estimator) {
        List values = this.getValues(interval);
        if (values.isEmpty()) {
            return null;
        }
        switch (estimator) {
            case AVERAGE: {
                throw new UnsupportedOperationException("Not supported estimator");
            }
            case MEDIAN: {
                if (values.size() % 2 == 1) {
                    return (Character)values.get(values.size() / 2);
                }
                return (Character)values.get(values.size() / 2 - 1);
            }
            case MODE: {
                Hashtable<Integer, Integer> map = new Hashtable<Integer, Integer>();
                for (int i = 0; i < values.size(); ++i) {
                    int prev = 0;
                    if (map.containsKey(((Character)values.get(i)).hashCode())) {
                        prev = (Integer)map.get(((Character)values.get(i)).hashCode());
                    }
                    map.put(((Character)values.get(i)).hashCode(), prev + 1);
                }
                int max = (Integer)map.get(((Character)values.get(0)).hashCode());
                int index = 0;
                for (int i = 1; i < values.size(); ++i) {
                    if (max >= (Integer)map.get(((Character)values.get(i)).hashCode())) continue;
                    max = (Integer)map.get(((Character)values.get(i)).hashCode());
                    index = i;
                }
                return (Character)values.get(index);
            }
            case SUM: {
                throw new UnsupportedOperationException("Not supported estimator");
            }
            case MIN: {
                Character minimum = (Character)values.get(0);
                for (int i = 1; i < values.size(); ++i) {
                    if (minimum.compareTo((Character)values.get(i)) <= 0) continue;
                    minimum = (Character)values.get(i);
                }
                return minimum;
            }
            case MAX: {
                Character maximum = (Character)values.get(0);
                for (int i = 1; i < values.size(); ++i) {
                    if (maximum.compareTo((Character)values.get(i)) >= 0) continue;
                    maximum = (Character)values.get(i);
                }
                return maximum;
            }
            case FIRST: {
                return (Character)values.get(0);
            }
            case LAST: {
                return (Character)values.get(values.size() - 1);
            }
        }
        throw new IllegalArgumentException("Unknown estimator.");
    }

    @Override
    public Class getUnderlyingType() {
        return Character.class;
    }
}

