/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.type;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Hashtable;
import java.util.List;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.Interval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DynamicDouble
extends DynamicType<Double> {
    public DynamicDouble() {
    }

    public DynamicDouble(Interval<Double> in) {
        super(in);
    }

    public DynamicDouble(List<Interval<Double>> in) {
        super(in);
    }

    public DynamicDouble(DynamicDouble source) {
        super(source);
    }

    public DynamicDouble(DynamicDouble source, Interval<Double> in) {
        super(source, in);
    }

    public DynamicDouble(DynamicDouble source, Interval<Double> in, Interval<Double> out) {
        super(source, in, out);
    }

    public DynamicDouble(DynamicDouble source, List<Interval<Double>> in) {
        super(source, in);
    }

    public DynamicDouble(DynamicDouble source, List<Interval<Double>> in, List<Interval<Double>> out) {
        super(source, in, out);
    }

    @Override
    public Double getValue(Interval interval, Estimator estimator) {
        List values = this.getValues(interval);
        if (values.isEmpty()) {
            return null;
        }
        switch (estimator) {
            case AVERAGE: {
                if (values.size() == 1) {
                    return (Double)values.get(0);
                }
                BigDecimal total = new BigDecimal(0);
                for (int i = 0; i < values.size(); ++i) {
                    total = total.add(BigDecimal.valueOf((Double)values.get(i)));
                }
                return total.divide(BigDecimal.valueOf(values.size()), 10, RoundingMode.HALF_EVEN).doubleValue();
            }
            case MEDIAN: {
                if (values.size() % 2 == 1) {
                    return (Double)values.get(values.size() / 2);
                }
                BigDecimal bd = new BigDecimal((Double)values.get(values.size() / 2 - 1));
                bd = bd.add(new BigDecimal((Double)values.get(values.size() / 2)));
                return bd.divide(new BigDecimal(2)).doubleValue();
            }
            case MODE: {
                Hashtable<Integer, Integer> map = new Hashtable<Integer, Integer>();
                for (int i = 0; i < values.size(); ++i) {
                    int prev = 0;
                    if (map.containsKey(((Double)values.get(i)).hashCode())) {
                        prev = (Integer)map.get(((Double)values.get(i)).hashCode());
                    }
                    map.put(((Double)values.get(i)).hashCode(), prev + 1);
                }
                int max = (Integer)map.get(((Double)values.get(0)).hashCode());
                int index = 0;
                for (int i = 1; i < values.size(); ++i) {
                    if (max >= (Integer)map.get(((Double)values.get(i)).hashCode())) continue;
                    max = (Integer)map.get(((Double)values.get(i)).hashCode());
                    index = i;
                }
                return (Double)values.get(index);
            }
            case SUM: {
                BigDecimal sum = new BigDecimal(0);
                for (int i = 0; i < values.size(); ++i) {
                    sum = sum.add(new BigDecimal((Double)values.get(i)));
                }
                return sum.doubleValue();
            }
            case MIN: {
                BigDecimal minimum = new BigDecimal((Double)values.get(0));
                for (int i = 1; i < values.size(); ++i) {
                    if (minimum.compareTo(new BigDecimal((Double)values.get(i))) <= 0) continue;
                    minimum = new BigDecimal((Double)values.get(i));
                }
                return minimum.doubleValue();
            }
            case MAX: {
                BigDecimal maximum = new BigDecimal((Double)values.get(0));
                for (int i = 1; i < values.size(); ++i) {
                    if (maximum.compareTo(new BigDecimal((Double)values.get(i))) >= 0) continue;
                    maximum = new BigDecimal((Double)values.get(i));
                }
                return maximum.doubleValue();
            }
            case FIRST: {
                return (Double)values.get(0);
            }
            case LAST: {
                return (Double)values.get(values.size() - 1);
            }
        }
        throw new IllegalArgumentException("Unknown estimator.");
    }

    @Override
    public Class getUnderlyingType() {
        return Double.class;
    }
}

