/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.type;

import java.util.Hashtable;
import java.util.List;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.Interval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DynamicString
extends DynamicType<String> {
    public DynamicString() {
    }

    public DynamicString(Interval<String> in) {
        super(in);
    }

    public DynamicString(List<Interval<String>> in) {
        super(in);
    }

    public DynamicString(DynamicString source) {
        super(source);
    }

    public DynamicString(DynamicString source, Interval<String> in) {
        super(source, in);
    }

    public DynamicString(DynamicString source, Interval<String> in, Interval<String> out) {
        super(source, in, out);
    }

    public DynamicString(DynamicString source, List<Interval<String>> in) {
        super(source, in);
    }

    public DynamicString(DynamicString source, List<Interval<String>> in, List<Interval<String>> out) {
        super(source, in, out);
    }

    @Override
    public String getValue(Interval interval, Estimator estimator) {
        List values = this.getValues(interval);
        if (values.isEmpty()) {
            return null;
        }
        switch (estimator) {
            case AVERAGE: {
                throw new UnsupportedOperationException("Not supported estimator");
            }
            case MEDIAN: {
                if (values.size() % 2 == 1) {
                    return (String)values.get(values.size() / 2);
                }
                return (String)values.get(values.size() / 2 - 1);
            }
            case MODE: {
                Hashtable<Integer, Integer> map = new Hashtable<Integer, Integer>();
                for (int i = 0; i < values.size(); ++i) {
                    int prev = 0;
                    if (map.containsKey(((String)values.get(i)).hashCode())) {
                        prev = (Integer)map.get(((String)values.get(i)).hashCode());
                    }
                    map.put(((String)values.get(i)).hashCode(), prev + 1);
                }
                int max = (Integer)map.get(((String)values.get(0)).hashCode());
                int index = 0;
                for (int i = 1; i < values.size(); ++i) {
                    if (max >= (Integer)map.get(((String)values.get(i)).hashCode())) continue;
                    max = (Integer)map.get(((String)values.get(i)).hashCode());
                    index = i;
                }
                return (String)values.get(index);
            }
            case SUM: {
                throw new UnsupportedOperationException("Not supported estimator");
            }
            case MIN: {
                String minimum = (String)values.get(0);
                for (int i = 1; i < values.size(); ++i) {
                    if (minimum.compareTo((String)values.get(i)) <= 0) continue;
                    minimum = (String)values.get(i);
                }
                return minimum;
            }
            case MAX: {
                String maximum = (String)values.get(0);
                for (int i = 1; i < values.size(); ++i) {
                    if (maximum.compareTo((String)values.get(i)) >= 0) continue;
                    maximum = (String)values.get(i);
                }
                return maximum;
            }
            case FIRST: {
                return (String)values.get(0);
            }
            case LAST: {
                return (String)values.get(values.size() - 1);
            }
        }
        throw new IllegalArgumentException("Unknown estimator.");
    }

    @Override
    public Class getUnderlyingType() {
        return String.class;
    }
}

