/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.type;

import java.util.ArrayList;
import java.util.List;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.Interval;
import org.gephi.data.attributes.type.IntervalTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DynamicType<T> {
    protected IntervalTree<T> intervalTree;

    public DynamicType() {
        this.intervalTree = new IntervalTree();
    }

    public DynamicType(Interval<T> in) {
        this();
        if (in != null) {
            this.intervalTree.insert(in);
        }
    }

    public DynamicType(List<Interval<T>> in) {
        this();
        if (in != null) {
            for (Interval<T> interval : in) {
                this.intervalTree.insert(interval);
            }
        }
    }

    public DynamicType(DynamicType<T> source) {
        this.intervalTree = source == null ? new IntervalTree() : new IntervalTree(source.intervalTree);
    }

    public DynamicType(DynamicType<T> source, Interval<T> in) {
        this(source);
        if (in != null) {
            this.intervalTree.insert(in);
        }
    }

    public DynamicType(DynamicType<T> source, Interval<T> in, Interval<T> out) {
        this(source);
        if (out != null) {
            this.intervalTree.delete(out);
        }
        if (in != null) {
            this.intervalTree.insert(in);
        }
    }

    public DynamicType(DynamicType<T> source, List<Interval<T>> in) {
        this(source);
        if (in != null) {
            for (Interval<T> interval : in) {
                this.intervalTree.insert(interval);
            }
        }
    }

    public DynamicType(DynamicType<T> source, List<Interval<T>> in, List<Interval<T>> out) {
        this(source);
        if (out != null) {
            for (Interval<T> interval : out) {
                this.intervalTree.delete(interval);
            }
        }
        if (in != null) {
            for (Interval<T> interval : in) {
                this.intervalTree.insert(interval);
            }
        }
    }

    public double getLow() {
        return this.intervalTree.getLow();
    }

    public double getHigh() {
        return this.intervalTree.getHigh();
    }

    public boolean isLowExcluded() {
        return this.intervalTree.isLowExcluded();
    }

    public boolean isHighExcluded() {
        return this.intervalTree.isHighExcluded();
    }

    public boolean isInRange(Interval interval) {
        return this.intervalTree.overlapsWith(interval);
    }

    public boolean isInRange(double low, double high) {
        if (low > high) {
            throw new IllegalArgumentException("The left endpoint of the interval must be less than the right endpoint.");
        }
        return this.intervalTree.overlapsWith(new Interval(low, high));
    }

    public T getValue() {
        return this.getValue(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public T getValue(Interval interval) {
        return this.getValue(interval, Estimator.FIRST);
    }

    public T getValue(double low, double high) {
        return this.getValue(low, high, Estimator.FIRST);
    }

    public T getValue(Estimator estimator) {
        return this.getValue(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, estimator);
    }

    public abstract T getValue(Interval var1, Estimator var2);

    public T getValue(double low, double high, Estimator estimator) {
        if (low > high) {
            throw new IllegalArgumentException("The left endpoint of the interval must be less than the right endpoint.");
        }
        return this.getValue(new Interval(low, high, false, false), estimator);
    }

    public List<T> getValues() {
        return this.getValues(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public List<T> getValues(double low, double high) {
        return this.getValues(new Interval(low, high));
    }

    public List<T> getValues(Interval interval) {
        ArrayList<T> result = new ArrayList<T>();
        for (Interval<T> i : this.intervalTree.search(interval)) {
            result.add(i.getValue());
        }
        return result;
    }

    public List<Interval<T>> getIntervals(Interval interval) {
        return this.intervalTree.search(interval);
    }

    public List<Interval<T>> getIntervals(double low, double high) {
        return this.intervalTree.search(low, high);
    }

    public abstract Class getUnderlyingType();

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass()) && ((DynamicType)obj).intervalTree.equals(this.intervalTree);
    }

    public int hashCode() {
        return this.intervalTree.hashCode();
    }

    public String toString(boolean timesAsDoubles) {
        return this.intervalTree.toString(timesAsDoubles);
    }

    public String toString() {
        return this.intervalTree.toString();
    }
}

