/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.type;

import org.gephi.data.attributes.api.AttributeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Interval<T>
implements Comparable<Interval> {
    private double low;
    private double high;
    private boolean lopen;
    private boolean ropen;
    private T value;

    public Interval(double low, double high, boolean lopen, boolean ropen, T value) {
        if (low > high) {
            throw new IllegalArgumentException("The left endpoint of the interval must be less than the right endpoint.");
        }
        this.low = low;
        this.high = high;
        this.lopen = lopen;
        this.ropen = ropen;
        this.value = value;
    }

    public Interval(double low, double high, boolean lopen, boolean ropen) {
        this(low, high, lopen, ropen, null);
    }

    public Interval(double low, double high, T value) {
        this(low, high, false, false, value);
    }

    public Interval(double low, double high) {
        this(low, high, false, false, null);
    }

    @Override
    public int compareTo(Interval interval) {
        if (interval == null) {
            throw new NullPointerException("Interval cannot be null.");
        }
        if (this.high < interval.low || this.high <= interval.low && (this.ropen || interval.lopen)) {
            return -1;
        }
        if (interval.high < this.low || interval.high <= this.low && (interval.ropen || this.lopen)) {
            return 1;
        }
        return 0;
    }

    public double getLow() {
        return this.low;
    }

    public double getHigh() {
        return this.high;
    }

    public boolean isLowExcluded() {
        return this.lopen;
    }

    public boolean isHighExcluded() {
        return this.ropen;
    }

    public T getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            Interval interval = (Interval)obj;
            if (this.low == interval.low && this.high == interval.high && this.lopen == interval.lopen && this.ropen == interval.ropen) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.low) ^ Double.doubleToLongBits(this.low) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.high) ^ Double.doubleToLongBits(this.high) >>> 32);
        hash = 97 * hash + (this.lopen ? 1 : 0);
        hash = 97 * hash + (this.ropen ? 1 : 0);
        return hash;
    }

    public String toString(boolean timesAsDoubles) {
        if (timesAsDoubles) {
            return (this.lopen ? "(" : "[") + this.low + ", " + this.high + ", " + this.value + (this.ropen ? ")" : "]");
        }
        return (this.lopen ? "(" : "[") + AttributeUtils.getXMLDateStringFromDouble(this.low) + ", " + AttributeUtils.getXMLDateStringFromDouble(this.high) + ", " + this.value + (this.ropen ? ")" : "]");
    }

    public String toString() {
        return this.toString(true);
    }
}

