/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.type;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.gephi.data.attributes.api.AttributeUtils;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.Interval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeInterval
extends DynamicType<Double[]> {
    public TimeInterval() {
    }

    public TimeInterval(double low, double high, boolean lopen, boolean ropen) {
        super(new Interval(low, high, lopen, ropen));
    }

    public TimeInterval(double low, double high) {
        super(new Interval(low, high));
    }

    public TimeInterval(List<Interval> in) {
        super(TimeInterval.getList(in));
    }

    public TimeInterval(TimeInterval source) {
        super(source);
    }

    public TimeInterval(TimeInterval source, double low, double high, boolean lopen, boolean ropen) {
        super(source, new Interval(low, high, lopen, ropen));
    }

    public TimeInterval(TimeInterval source, double low, double high) {
        super(source, new Interval(low, high));
    }

    public TimeInterval(TimeInterval source, double alow, double ahigh, boolean alopen, boolean aropen, double rlow, double rhigh, boolean blopen, boolean bropen) {
        super(source, new Interval(alow, ahigh, alopen, aropen), new Interval(rlow, rhigh, blopen, bropen));
    }

    public TimeInterval(TimeInterval source, double alow, double ahigh, double rlow, double rhigh) {
        super(source, new Interval(alow, ahigh), new Interval(rlow, rhigh));
    }

    public TimeInterval(TimeInterval source, List<Interval> in) {
        super(source, TimeInterval.getList(in));
    }

    public TimeInterval(TimeInterval source, List<Interval> in, List<Interval> out) {
        super(source, TimeInterval.getList(in), TimeInterval.getList(out));
    }

    private static List<Interval<Double[]>> getList(List<Interval> arg) {
        if (arg == null) {
            return null;
        }
        ArrayList<Interval<Double[]>> list = new ArrayList<Interval<Double[]>>();
        for (Interval item : arg) {
            list.add(new Interval(item.getLow(), item.getHigh(), item.isLowExcluded(), item.isHighExcluded()));
        }
        return list;
    }

    @Override
    public Double[] getValue(Interval interval, Estimator estimator) {
        List<Double[]> values = this.getValues(interval);
        if (values.isEmpty()) {
            return null;
        }
        switch (estimator) {
            case AVERAGE: {
                throw new UnsupportedOperationException("Not supported estimator");
            }
            case MEDIAN: {
                if (values.size() % 2 == 1) {
                    return values.get(values.size() / 2);
                }
                return values.get(values.size() / 2 - 1);
            }
            case MODE: {
                Hashtable<Integer, Integer> map = new Hashtable<Integer, Integer>();
                for (int i = 0; i < values.size(); ++i) {
                    int prev = 0;
                    if (map.containsKey(values.get(i).hashCode())) {
                        prev = (Integer)map.get(values.get(i).hashCode());
                    }
                    map.put(values.get(i).hashCode(), prev + 1);
                }
                int max = (Integer)map.get(values.get(0).hashCode());
                int index = 0;
                for (int i = 1; i < values.size(); ++i) {
                    if (max >= (Integer)map.get(values.get(i).hashCode())) continue;
                    max = (Integer)map.get(values.get(i).hashCode());
                    index = i;
                }
                return values.get(index);
            }
            case SUM: {
                throw new UnsupportedOperationException("Not supported estimator");
            }
            case MIN: {
                throw new UnsupportedOperationException("Not supported estimator");
            }
            case MAX: {
                throw new UnsupportedOperationException("Not supported estimator");
            }
            case FIRST: {
                return values.get(0);
            }
            case LAST: {
                return values.get(values.size() - 1);
            }
        }
        throw new IllegalArgumentException("Unknown estimator.");
    }

    @Override
    public List<Double[]> getValues(Interval interval) {
        ArrayList<Double[]> result = new ArrayList<Double[]>();
        for (Interval i : this.intervalTree.search(interval)) {
            result.add(new Double[]{i.getLow(), i.getHigh()});
        }
        return result;
    }

    @Override
    public Class getUnderlyingType() {
        return Double[].class;
    }

    @Override
    public String toString(boolean timesAsDoubles) {
        if (timesAsDoubles) {
            return this.toString();
        }
        return this.toStringTimesAsDates();
    }

    public String toStringTimesAsDates() {
        List list = this.getIntervals(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        if (!list.isEmpty()) {
            StringBuilder sb = new StringBuilder("<");
            sb.append(list.get(0).isLowExcluded() ? "(" : "[").append(AttributeUtils.getXMLDateStringFromDouble(list.get(0).getLow())).append(", ").append(AttributeUtils.getXMLDateStringFromDouble(list.get(0).getHigh())).append(list.get(0).isHighExcluded() ? ")" : "]");
            for (int i = 1; i < list.size(); ++i) {
                sb.append("; ").append(list.get(i).isLowExcluded() ? "(" : "[").append(AttributeUtils.getXMLDateStringFromDouble(list.get(i).getLow())).append(", ").append(AttributeUtils.getXMLDateStringFromDouble(list.get(i).getHigh())).append(list.get(i).isHighExcluded() ? ")" : "]");
            }
            sb.append(">");
            return sb.toString();
        }
        return "<empty>";
    }

    @Override
    public String toString() {
        List list = this.getIntervals(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        if (!list.isEmpty()) {
            StringBuilder sb = new StringBuilder("<");
            sb.append(list.get(0).isLowExcluded() ? "(" : "[").append(list.get(0).getLow()).append(", ").append(list.get(0).getHigh()).append(list.get(0).isHighExcluded() ? ")" : "]");
            for (int i = 1; i < list.size(); ++i) {
                sb.append("; ").append(list.get(i).isLowExcluded() ? "(" : "[").append(list.get(i).getLow()).append(", ").append(list.get(i).getHigh()).append(list.get(i).isHighExcluded() ? ")" : "]");
            }
            sb.append(">");
            return sb.toString();
        }
        return "<empty>";
    }
}

