/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.type;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.gephi.data.attributes.api.AttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeConvertor {
    private static final String CONVERSION_METHOD_NAME = "valueOf";

    private TypeConvertor() {
    }

    public static <T> T[] createArrayFromString(String input, String separator, Class<T> finalType) {
        if (input == null || separator == null || finalType == null) {
            throw new NullPointerException();
        }
        String[] stringValues = input.split(separator);
        Object[] resultList = (Object[])Array.newInstance(finalType, stringValues.length);
        for (int i = 0; i < stringValues.length; ++i) {
            String stringValue = stringValues[i].trim();
            String resultValue = null;
            resultValue = finalType == String.class ? stringValue : TypeConvertor.createInstanceFromString(stringValue, finalType);
            resultList[i] = resultValue;
        }
        return resultList;
    }

    public static <T> T createInstanceFromString(String input, Class<T> finalType) {
        if (input == null || finalType == null) {
            throw new NullPointerException();
        }
        Object resultValue = null;
        try {
            Method conversionMethod = finalType.getMethod(CONVERSION_METHOD_NAME, String.class);
            resultValue = conversionMethod.invoke(null, input);
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor<T> constructor = finalType.getConstructor(String.class);
                resultValue = constructor.newInstance(input);
            }
            catch (NoSuchMethodException e1) {
                String errorMessage = String.format("Type '%s' does not have neither method 'T %s(String)' nor  constructor '<init>(String)'...", finalType, CONVERSION_METHOD_NAME);
                throw new IllegalArgumentException(errorMessage);
            }
            catch (Exception e2) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)resultValue;
    }

    public static <T> T[] convertPrimitiveToWrapperArray(Object primitiveArray) {
        if (primitiveArray == null) {
            throw new NullPointerException();
        }
        if (!primitiveArray.getClass().isArray()) {
            throw new IllegalArgumentException("Given object is not of primitive array: " + primitiveArray.getClass());
        }
        Class<?> primitiveClass = primitiveArray.getClass().getComponentType();
        Class<?> wrapperClass = TypeConvertor.getWrapperFromPrimitive(primitiveClass);
        int arrayLength = Array.getLength(primitiveArray);
        Object[] wrapperArray = (Object[])Array.newInstance(wrapperClass, arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            Object arrayItem;
            wrapperArray[i] = arrayItem = Array.get(primitiveArray, i);
        }
        return wrapperArray;
    }

    public static Class<?> getWrapperFromPrimitive(Class<?> primitiveType) {
        if (primitiveType == null) {
            throw new NullPointerException();
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        throw new IllegalArgumentException("Given type '" + primitiveType + "' is not primitive...");
    }

    public static AttributeType getStaticType(AttributeType dynamicType) {
        if (!dynamicType.isDynamicType()) {
            throw new IllegalArgumentException("Given type '" + (Object)((Object)dynamicType) + "' is not dynamic.");
        }
        switch (dynamicType) {
            case DYNAMIC_BIGDECIMAL: {
                return AttributeType.BIGDECIMAL;
            }
            case DYNAMIC_BIGINTEGER: {
                return AttributeType.BIGINTEGER;
            }
            case DYNAMIC_BOOLEAN: {
                return AttributeType.BOOLEAN;
            }
            case DYNAMIC_BYTE: {
                return AttributeType.BYTE;
            }
            case DYNAMIC_CHAR: {
                return AttributeType.CHAR;
            }
            case DYNAMIC_DOUBLE: {
                return AttributeType.DOUBLE;
            }
            case DYNAMIC_FLOAT: {
                return AttributeType.FLOAT;
            }
            case DYNAMIC_INT: {
                return AttributeType.INT;
            }
            case DYNAMIC_LONG: {
                return AttributeType.LONG;
            }
            case DYNAMIC_SHORT: {
                return AttributeType.SHORT;
            }
            case DYNAMIC_STRING: {
                return AttributeType.STRING;
            }
        }
        return null;
    }

    public static AttributeType getDynamicType(AttributeType staticType) {
        if (staticType.isDynamicType()) {
            throw new IllegalArgumentException("Given type '" + (Object)((Object)staticType) + "' is not static.");
        }
        switch (staticType) {
            case BIGDECIMAL: {
                return AttributeType.DYNAMIC_BIGDECIMAL;
            }
            case BIGINTEGER: {
                return AttributeType.DYNAMIC_BIGINTEGER;
            }
            case BOOLEAN: {
                return AttributeType.DYNAMIC_BOOLEAN;
            }
            case BYTE: {
                return AttributeType.DYNAMIC_BYTE;
            }
            case CHAR: {
                return AttributeType.DYNAMIC_CHAR;
            }
            case DOUBLE: {
                return AttributeType.DYNAMIC_DOUBLE;
            }
            case FLOAT: {
                return AttributeType.DYNAMIC_FLOAT;
            }
            case INT: {
                return AttributeType.DYNAMIC_INT;
            }
            case LONG: {
                return AttributeType.DYNAMIC_LONG;
            }
            case SHORT: {
                return AttributeType.DYNAMIC_SHORT;
            }
            case STRING: {
                return AttributeType.DYNAMIC_STRING;
            }
        }
        return null;
    }
}

