/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.impl;

import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.datalab.api.DataTablesController;
import org.gephi.datalab.api.DataTablesEventListener;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Node;
import org.openide.util.Lookup;

public class DataTablesControllerImpl
implements DataTablesController {
    DataTablesEventListener listener;

    public void setDataTablesEventListener(DataTablesEventListener listener) {
        this.listener = listener;
    }

    public DataTablesEventListener getDataTablesEventListener() {
        return this.listener;
    }

    public boolean isDataTablesReady() {
        return this.listener != null;
    }

    public void selectNodesTable() {
        if (this.listener != null) {
            this.listener.selectNodesTable();
        }
    }

    public void selectEdgesTable() {
        if (this.listener != null) {
            this.listener.selectEdgesTable();
        }
    }

    public void selectTable(AttributeTable table) {
        if (this.listener != null) {
            AttributeController ac = (AttributeController)Lookup.getDefault().lookup(AttributeController.class);
            if (ac.getModel().getNodeTable() == table) {
                this.selectNodesTable();
            } else {
                this.selectEdgesTable();
            }
        }
    }

    public void refreshCurrentTable() {
        if (this.listener != null) {
            this.listener.refreshCurrentTable();
        }
    }

    public void setNodeTableSelection(Node[] nodes) {
        if (this.listener != null) {
            this.listener.setNodeTableSelection(nodes);
        }
    }

    public void setEdgeTableSelection(Edge[] edges) {
        if (this.listener != null) {
            this.listener.setEdgeTableSelection(edges);
        }
    }

    public Node[] getNodeTableSelection() {
        if (this.listener != null) {
            return this.listener.getNodeTableSelection();
        }
        return null;
    }

    public Edge[] getEdgeTableSelection() {
        if (this.listener != null) {
            return this.listener.getEdgeTableSelection();
        }
        return null;
    }

    public boolean isNodeTableMode() {
        if (this.listener != null) {
            return this.listener.isNodeTableMode();
        }
        return false;
    }

    public boolean isEdgeTableMode() {
        if (this.listener != null) {
            return this.listener.isEdgeTableMode();
        }
        return false;
    }

    public boolean isShowOnlyVisible() {
        if (this.listener != null) {
            return this.listener.isShowOnlyVisible();
        }
        return false;
    }

    public void setShowOnlyVisible(boolean showOnlyVisible) {
        if (this.listener != null) {
            this.listener.setShowOnlyVisible(showOnlyVisible);
        }
    }

    public void exportCurrentTable(DataTablesEventListener.ExportMode exportMode) {
        if (this.listener != null) {
            this.listener.exportCurrentTable(exportMode);
        }
    }

    public boolean isUseSparklines() {
        if (this.listener != null) {
            return this.listener.isUseSparklines();
        }
        return false;
    }

    public void setUseSparklines(boolean useSparklines) {
        if (this.listener != null) {
            this.listener.setUseSparklines(useSparklines);
        }
    }

    public boolean isTimeIntervalGraphics() {
        if (this.listener != null) {
            return this.listener.isTimeIntervalGraphics();
        }
        return false;
    }

    public void setTimeIntervalGraphics(boolean timeIntervalGraphics) {
        if (this.listener != null) {
            this.listener.setTimeIntervalGraphics(timeIntervalGraphics);
        }
    }

    public boolean isShowEdgesNodesLabels() {
        if (this.listener != null) {
            return this.listener.isShowEdgesNodesLabels();
        }
        return false;
    }

    public void setShowEdgesNodesLabels(boolean showEdgesNodesLabels) {
        if (this.listener != null) {
            this.listener.setShowEdgesNodesLabels(showEdgesNodesLabels);
        }
    }
}

