/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.datalab.api.GraphElementsController;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeData;
import org.gephi.graph.api.UndirectedGraph;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class GraphElementsControllerImpl
implements GraphElementsController {
    private static final float DEFAULT_NODE_SIZE = 10.0f;
    private static final float DEFAULT_EDGE_WEIGHT = 1.0f;

    public Node createNode(String label) {
        Node newNode = this.buildNode(label);
        this.getGraph().addNode(newNode);
        return newNode;
    }

    public Node createNode(String label, String id) {
        Graph graph = this.getGraph();
        if (graph.getNode(id) == null) {
            Node newNode = this.buildNode(label, id);
            graph.addNode(newNode);
            return newNode;
        }
        return null;
    }

    public Node duplicateNode(Node node) {
        if (this.isNodeInGraph(node)) {
            HierarchicalGraph hg = this.getHierarchicalGraph();
            Node copy = this.copyNodeRecursively(node, hg.getParent(node), hg);
            return copy;
        }
        return null;
    }

    public void duplicateNodes(Node[] nodes) {
        for (Node n : nodes) {
            this.duplicateNode(n);
        }
    }

    public Edge createEdge(Node source, Node target, boolean directed) {
        if (directed) {
            Edge newEdge = this.buildEdge(source, target, true);
            if (this.getDirectedGraph().addEdge(newEdge)) {
                return newEdge;
            }
            return null;
        }
        Edge newEdge = this.buildEdge(source, target, false);
        if (this.getUndirectedGraph().addEdge(newEdge)) {
            return newEdge;
        }
        return null;
    }

    public Edge createEdge(String id, Node source, Node target, boolean directed) {
        if (source != target) {
            if (directed) {
                Edge newEdge = this.buildEdge(id, source, target, true);
                if (this.getDirectedGraph().addEdge(newEdge)) {
                    return newEdge;
                }
                return null;
            }
            Edge newEdge = this.buildEdge(id, source, target, false);
            if (this.getUndirectedGraph().addEdge(newEdge)) {
                return newEdge;
            }
            return null;
        }
        return null;
    }

    public void createEdges(Node source, Node[] allNodes, boolean directed) {
        if (this.isNodeInGraph(source) && this.areNodesInGraph(allNodes)) {
            for (Node n : allNodes) {
                if (n == source) continue;
                this.createEdge(source, n, directed);
            }
        }
    }

    public void deleteNode(Node node) {
        this.removeNode(node, this.getGraph());
    }

    public void deleteNodes(Node[] nodes) {
        Graph graph = this.getGraph();
        for (Node node : nodes) {
            this.removeNode(node, graph);
        }
    }

    public void deleteEdge(Edge edge) {
        this.removeEdge(edge, this.getGraph());
    }

    public void deleteEdges(Edge[] edges) {
        Graph graph = this.getGraph();
        for (Edge edge : edges) {
            this.removeEdge(edge, graph);
        }
    }

    public void deleteEdgeWithNodes(Edge edge, boolean deleteSource, boolean deleteTarget) {
        if (deleteSource) {
            this.deleteNode(edge.getSource());
        }
        if (deleteTarget) {
            this.deleteNode(edge.getTarget());
        }
        this.removeEdge(edge, this.getGraph());
    }

    public void deleteEdgesWithNodes(Edge[] edges, boolean deleteSource, boolean deleteTarget) {
        for (Edge edge : edges) {
            this.deleteEdgeWithNodes(edge, deleteSource, deleteTarget);
        }
    }

    public boolean groupNodes(Node[] nodes) {
        if (this.canGroupNodes(nodes)) {
            HierarchicalGraph hg = this.getHierarchicalGraph();
            Node group = hg.groupNodes(nodes);
            group.getNodeData().setLabel(NbBundle.getMessage(GraphElementsControllerImpl.class, (String)"Group.nodeCount.label", (Object)this.getNodeChildrenCount(hg, group)));
            return true;
        }
        return false;
    }

    public boolean canGroupNodes(Node[] nodes) {
        if (!this.areNodesInGraph(nodes)) {
            return false;
        }
        HierarchicalGraph hg = this.getHierarchicalGraph();
        Node parent = hg.getParent(nodes[0]);
        for (Node n : nodes) {
            if (hg.getParent(n) == parent) continue;
            return false;
        }
        return true;
    }

    public boolean ungroupNode(Node node) {
        if (this.canUngroupNode(node)) {
            HierarchicalGraph hg = this.getHierarchicalGraph();
            hg.ungroupNodes(node);
            return true;
        }
        return false;
    }

    public void ungroupNodes(Node[] nodes) {
        for (Node n : nodes) {
            this.ungroupNode(n);
        }
    }

    public boolean ungroupNodeRecursively(Node node) {
        if (this.canUngroupNode(node)) {
            HierarchicalGraph hg = this.getHierarchicalGraph();
            this.ungroupNodes(hg.getDescendant(node).toArray());
            this.ungroupNode(node);
            return true;
        }
        return false;
    }

    public void ungroupNodesRecursively(Node[] nodes) {
        for (Node n : nodes) {
            this.ungroupNodeRecursively(n);
        }
    }

    public boolean canUngroupNode(Node node) {
        if (!this.isNodeInGraph(node)) {
            return false;
        }
        HierarchicalGraph hg = this.getHierarchicalGraph();
        boolean canUngroup = this.getNodeChildrenCount(hg, node) > 0;
        return canUngroup;
    }

    public boolean moveNodeToGroup(Node node, Node group) {
        if (this.canMoveNodeToGroup(node, group)) {
            this.getHierarchicalGraph().moveToGroup(node, group);
            return true;
        }
        return false;
    }

    public void moveNodesToGroup(Node[] nodes, Node group) {
        for (Node n : nodes) {
            this.moveNodeToGroup(n, group);
        }
    }

    public Node[] getAvailableGroupsToMoveNodes(Node[] nodes) {
        if (this.canGroupNodes(nodes)) {
            HierarchicalGraph hg = this.getHierarchicalGraph();
            HashSet<Node> nodesSet = new HashSet<Node>();
            nodesSet.addAll(Arrays.asList(nodes));
            Node parent = hg.getParent(nodes[0]);
            Node[] possibleGroups = parent != null ? hg.getChildren(parent).toArray() : hg.getNodes(0).toArray();
            ArrayList<Node> availableGroups = new ArrayList<Node>();
            for (Node n : possibleGroups) {
                if (nodesSet.contains(n) || this.getNodeChildrenCount(hg, n) <= 0) continue;
                availableGroups.add(n);
            }
            return availableGroups.toArray(new Node[0]);
        }
        return null;
    }

    public boolean canMoveNodeToGroup(Node node, Node group) {
        HierarchicalGraph hg = this.getHierarchicalGraph();
        return node != group && hg.getParent(node) == hg.getParent(group) && this.canUngroupNode(group) && this.isNodeInGraph(node);
    }

    public boolean removeNodeFromGroup(Node node) {
        if (this.isNodeInGroup(node)) {
            HierarchicalGraph hg = this.getHierarchicalGraph();
            Node parent = hg.getParent(node);
            hg.readLock();
            int childrenCount = hg.getChildrenCount(parent);
            hg.readUnlock();
            if (childrenCount == 1) {
                hg.ungroupNodes(parent);
            } else {
                hg.removeFromGroup(node);
            }
            return true;
        }
        return false;
    }

    public void removeNodesFromGroup(Node[] nodes) {
        for (Node n : nodes) {
            this.removeNodeFromGroup(n);
        }
    }

    public boolean isNodeInGroup(Node node) {
        if (!this.isNodeInGraph(node)) {
            return false;
        }
        HierarchicalGraph hg = this.getHierarchicalGraph();
        return hg.getParent(node) != null;
    }

    public void setNodeFixed(Node node, boolean fixed) {
        if (this.isNodeInGraph(node)) {
            node.getNodeData().setFixed(fixed);
        }
    }

    public void setNodesFixed(Node[] nodes, boolean fixed) {
        for (Node n : nodes) {
            this.setNodeFixed(n, fixed);
        }
    }

    public boolean isNodeFixed(Node node) {
        return node.getNodeData().isFixed();
    }

    public Node[] getNodeNeighbours(Node node) {
        return this.getGraph().getNeighbors(node).toArray();
    }

    public Edge[] getNodeEdges(Node node) {
        return this.getGraph().getEdges(node).toArray();
    }

    public int getNodesCount() {
        Graph graph = this.getGraph();
        graph.readLock();
        int nodesCount = graph.getNodeCount();
        graph.readUnlock();
        return nodesCount;
    }

    public int getEdgesCount() {
        Graph graph = this.getGraph();
        graph.readLock();
        int edgesCount = graph.getEdgeCount();
        graph.readUnlock();
        return edgesCount;
    }

    public boolean isNodeInGraph(Node node) {
        return this.getGraph().contains(node);
    }

    public boolean areNodesInGraph(Node[] nodes) {
        Graph graph = this.getGraph();
        for (Node n : nodes) {
            if (graph.contains(n)) continue;
            return false;
        }
        return true;
    }

    public boolean isEdgeInGraph(Edge edge) {
        return this.getGraph().contains(edge);
    }

    public boolean areEdgesInGraph(Edge[] edges) {
        Graph graph = this.getGraph();
        for (Edge e : edges) {
            if (graph.contains(e)) continue;
            return false;
        }
        return true;
    }

    private Graph getGraph() {
        return ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel().getGraph();
    }

    private DirectedGraph getDirectedGraph() {
        return ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel().getDirectedGraph();
    }

    private UndirectedGraph getUndirectedGraph() {
        return ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel().getUndirectedGraph();
    }

    private HierarchicalGraph getHierarchicalGraph() {
        return ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel().getHierarchicalGraph();
    }

    private Node buildNode(String label) {
        Node newNode = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel().factory().newNode();
        newNode.getNodeData().setSize(10.0f);
        newNode.getNodeData().setLabel(label);
        return newNode;
    }

    private Node buildNode(String label, String id) {
        Node newNode = this.buildNode(label);
        this.getGraph().setId(newNode, id);
        return newNode;
    }

    private Edge buildEdge(Node source, Node target, boolean directed) {
        Edge newEdge = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel().factory().newEdge(source, target, 1.0f, directed);
        return newEdge;
    }

    private Edge buildEdge(String id, Node source, Node target, boolean directed) {
        Edge newEdge = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel().factory().newEdge(id, source, target, 1.0f, directed);
        return newEdge;
    }

    private Node copyNodeRecursively(Node node, Node parent, HierarchicalGraph hg) {
        NodeData nodeData = node.getNodeData();
        Node copy = this.buildNode(nodeData.getLabel());
        NodeData copyData = copy.getNodeData();
        copyData.setX(nodeData.x());
        copyData.setY(nodeData.y());
        copyData.setZ(nodeData.z());
        copyData.setSize(nodeData.getSize());
        copyData.setColor(nodeData.r(), nodeData.g(), nodeData.b());
        copyData.setAlpha(nodeData.alpha());
        AttributeRow row = (AttributeRow)nodeData.getAttributes();
        for (int i = 0; i < row.countValues(); ++i) {
            if (row.getValues()[i].getColumn().getOrigin() != AttributeOrigin.DATA) continue;
            copyData.getAttributes().setValue(i, row.getValue(i));
        }
        if (parent != null) {
            hg.addNode(copy, parent);
        } else {
            hg.addNode(copy);
        }
        Node[] children = hg.getChildren(node).toArray();
        if (children != null) {
            for (Node child : children) {
                this.copyNodeRecursively(child, copy, hg);
            }
        }
        return copy;
    }

    private void removeNode(Node node, Graph graph) {
        if (this.isNodeInGraph(node)) {
            graph.removeNode(node);
        }
    }

    private void removeEdge(Edge edge, Graph graph) {
        if (this.isEdgeInGraph(edge)) {
            graph.removeEdge(edge);
        }
    }

    private int getNodeChildrenCount(HierarchicalGraph hg, Node n) {
        hg.readLock();
        int childrenCount = hg.getChildrenCount(n);
        hg.readUnlock();
        return childrenCount;
    }
}

