/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.dynamic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.dynamic.DynamicModelImpl;
import org.gephi.dynamic.api.DynamicController;
import org.gephi.dynamic.api.DynamicModel;
import org.gephi.dynamic.api.DynamicModelEvent;
import org.gephi.dynamic.api.DynamicModelListener;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.project.api.WorkspaceProvider;
import org.openide.util.Lookup;

public final class DynamicControllerImpl
implements DynamicController {
    private DynamicModelImpl model;
    private List<DynamicModelListener> listeners = Collections.synchronizedList(new ArrayList());
    private DynamicModelEventDispatchThread eventThread = new DynamicModelEventDispatchThread();

    public DynamicControllerImpl() {
        this.eventThread.start();
        ProjectController projectController = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        projectController.addWorkspaceListener(new WorkspaceListener(){

            @Override
            public void initialize(Workspace workspace) {
            }

            @Override
            public void select(Workspace workspace) {
                DynamicControllerImpl.this.model = (DynamicModelImpl)workspace.getLookup().lookup(DynamicModelImpl.class);
                if (DynamicControllerImpl.this.model == null) {
                    DynamicControllerImpl.this.model = new DynamicModelImpl(DynamicControllerImpl.this, workspace);
                    workspace.add(DynamicControllerImpl.this.model);
                }
            }

            @Override
            public void unselect(Workspace workspace) {
            }

            @Override
            public void close(Workspace workspace) {
            }

            @Override
            public void disable() {
                DynamicControllerImpl.this.model = null;
            }
        });
        if (projectController.getCurrentProject() != null) {
            Workspace[] workspaces;
            for (Workspace workspace : workspaces = ((WorkspaceProvider)projectController.getCurrentProject().getLookup().lookup(WorkspaceProvider.class)).getWorkspaces()) {
                DynamicModelImpl m = (DynamicModelImpl)workspace.getLookup().lookup(DynamicModelImpl.class);
                if (m == null) {
                    m = new DynamicModelImpl(this, workspace);
                    workspace.add(m);
                }
                if (workspace != projectController.getCurrentWorkspace()) continue;
                this.model = m;
            }
        }
    }

    @Override
    public DynamicModel getModel() {
        return this.model;
    }

    @Override
    public DynamicModel getModel(Workspace workspace) {
        if (workspace != null) {
            DynamicModel m = (DynamicModel)workspace.getLookup().lookup(DynamicModel.class);
            if (m != null) {
                return m;
            }
            m = new DynamicModelImpl(this, workspace);
            workspace.add(m);
            return m;
        }
        return null;
    }

    @Override
    public void setVisibleInterval(TimeInterval interval) {
        if (this.model != null) {
            this.model.setVisibleTimeInterval(interval);
        }
    }

    @Override
    public void setVisibleInterval(double low, double high) {
        this.setVisibleInterval(new TimeInterval(low, high));
    }

    @Override
    public void setTimeFormat(DynamicModel.TimeFormat timeFormat) {
        if (this.model != null) {
            this.model.setTimeFormat(timeFormat);
        }
    }

    @Override
    public void setEstimator(Estimator estimator) {
        if (this.model != null) {
            this.model.setEstimator(estimator);
        }
    }

    @Override
    public void setNumberEstimator(Estimator numberEstimator) {
        if (this.model != null) {
            this.model.setNumberEstimator(numberEstimator);
        }
    }

    @Override
    public void addModelListener(DynamicModelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeModelListener(DynamicModelListener listener) {
        this.listeners.remove(listener);
    }

    public void fireModelEvent(DynamicModelEvent event) {
        this.eventThread.fireEvent(event);
    }

    protected class DynamicModelEventDispatchThread
    extends Thread {
        private boolean stop;
        private final LinkedBlockingQueue<DynamicModelEvent> eventQueue;
        private final Object lock;

        public DynamicModelEventDispatchThread() {
            super("Dynamic Model EventDispatchThread");
            this.lock = new Object();
            this.setDaemon(true);
            this.eventQueue = new LinkedBlockingQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                DynamicModelEvent evt;
                while ((evt = this.eventQueue.poll()) != null) {
                    for (DynamicModelListener l : DynamicControllerImpl.this.listeners.toArray(new DynamicModelListener[0])) {
                        l.dynamicModelChanged(evt);
                    }
                }
                while (this.eventQueue.isEmpty()) {
                    try {
                        Object object = this.lock;
                        synchronized (object) {
                            this.lock.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }

        public void stop(boolean stop) {
            this.stop = stop;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireEvent(DynamicModelEvent event) {
            this.eventQueue.add(event);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }
}

