/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.dynamic;

import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.Interval;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.dynamic.api.DynamicGraph;
import org.gephi.graph.api.Attributes;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Node;

public final class DynamicGraphImpl
implements DynamicGraph {
    private GraphModel model;
    private GraphView sourceView;
    private GraphView currentView;
    private double low;
    private double high;

    public DynamicGraphImpl(Graph graph) {
        this(graph, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public DynamicGraphImpl(Graph graph, double low, double high) {
        if (graph == null) {
            throw new NullPointerException("The graph cannot be null.");
        }
        if (low > high) {
            throw new IllegalArgumentException("The left endpoint of the interval must be less than the right endpoint.");
        }
        this.model = graph.getGraphModel();
        this.sourceView = graph.getView();
        this.currentView = this.model.copyView(this.sourceView);
        this.low = low;
        this.high = high;
        if (low != Double.NEGATIVE_INFINITY || high != Double.POSITIVE_INFINITY) {
            TimeInterval ti;
            Graph vgraph = this.model.getGraph(this.currentView);
            for (Node n : vgraph.getNodes().toArray()) {
                ti = (TimeInterval)n.getNodeData().getAttributes().getValue("time_interval");
                if (ti.isInRange(low, high)) continue;
                vgraph.removeNode(n);
            }
            for (Edge e : vgraph.getEdges().toArray()) {
                ti = (TimeInterval)e.getEdgeData().getAttributes().getValue("time_interval");
                if (ti.isInRange(low, high)) continue;
                vgraph.removeEdge(e);
            }
        }
    }

    @Override
    public Object[] getAttributesValues(Node node, double point) {
        int count = node.getNodeData().getAttributes().countValues();
        Estimator[] estimators = new Estimator[count];
        for (int i = 0; i < count; ++i) {
            estimators[i] = Estimator.FIRST;
        }
        return this.getAttributesValues(node, point, estimators);
    }

    @Override
    public Object[] getAttributesValues(Node node, double point, Estimator[] estimators) {
        this.checkPoint(point);
        return this.getAttributesValues(node, point, point, estimators);
    }

    @Override
    public Object[] getAttributesValues(Node node, double low, double high) {
        this.checkLowHigh(low, high);
        return this.getAttributesValues(node, new Interval(low, high));
    }

    @Override
    public Object[] getAttributesValues(Node node, Interval interval) {
        int count = node.getNodeData().getAttributes().countValues();
        Estimator[] estimators = new Estimator[count];
        for (int i = 0; i < count; ++i) {
            estimators[i] = Estimator.FIRST;
        }
        return this.getAttributesValues(node, interval, estimators);
    }

    @Override
    public Object[] getAttributesValues(Node node, double low, double high, Estimator[] estimators) {
        this.checkLowHigh(low, high);
        return this.getAttributesValues(node, new Interval(low, high), estimators);
    }

    @Override
    public Object[] getAttributesValues(Node node, Interval interval, Estimator[] estimators) {
        this.checkEstimators(node, estimators);
        Attributes attributes = node.getNodeData().getAttributes();
        Object[] values = new Object[attributes.countValues()];
        for (int i = 0; i < attributes.countValues(); ++i) {
            values[i] = attributes.getValue(i);
            if (!(values[i] instanceof DynamicType)) continue;
            values[i] = ((DynamicType)values[i]).getValue(estimators[i]);
        }
        return values;
    }

    @Override
    public Object[] getAttributesValues(Edge edge, double point) {
        int count = edge.getEdgeData().getAttributes().countValues();
        Estimator[] estimators = new Estimator[count];
        for (int i = 0; i < count; ++i) {
            estimators[i] = Estimator.FIRST;
        }
        return this.getAttributesValues(edge, point, estimators);
    }

    @Override
    public Object[] getAttributesValues(Edge edge, double point, Estimator[] estimators) {
        this.checkPoint(point);
        return this.getAttributesValues(edge, point, point, estimators);
    }

    @Override
    public Object[] getAttributesValues(Edge edge, double low, double high) {
        this.checkLowHigh(low, high);
        return this.getAttributesValues(edge, new Interval(low, high));
    }

    @Override
    public Object[] getAttributesValues(Edge edge, Interval interval) {
        int count = edge.getEdgeData().getAttributes().countValues();
        Estimator[] estimators = new Estimator[count];
        for (int i = 0; i < count; ++i) {
            estimators[i] = Estimator.FIRST;
        }
        return this.getAttributesValues(edge, interval, estimators);
    }

    @Override
    public Object[] getAttributesValues(Edge edge, double low, double high, Estimator[] estimators) {
        this.checkLowHigh(low, high);
        return this.getAttributesValues(edge, new Interval(low, high), estimators);
    }

    @Override
    public Object[] getAttributesValues(Edge edge, Interval interval, Estimator[] estimators) {
        this.checkEstimators(edge, estimators);
        Attributes attributes = edge.getEdgeData().getAttributes();
        Object[] values = new Object[attributes.countValues()];
        for (int i = 0; i < attributes.countValues(); ++i) {
            values[i] = attributes.getValue(i);
            if (!(values[i] instanceof DynamicType)) continue;
            values[i] = ((DynamicType)values[i]).getValue(estimators[i]);
        }
        return values;
    }

    @Override
    public double getLow() {
        return this.low;
    }

    @Override
    public double getHigh() {
        return this.high;
    }

    @Override
    public Graph getSnapshotGraph(double point) {
        return this.getSnapshotGraph(point, Estimator.FIRST);
    }

    @Override
    public Graph getSnapshotGraph(double point, Estimator estimator) {
        this.checkPoint(point);
        return this.getSnapshotGraph(point, point, estimator);
    }

    @Override
    public Graph getSnapshotGraph(double low, double high) {
        return this.getSnapshotGraph(low, high, Estimator.FIRST);
    }

    @Override
    public Graph getSnapshotGraph(Interval interval) {
        return this.getSnapshotGraph(interval, Estimator.FIRST);
    }

    @Override
    public Graph getSnapshotGraph(double low, double high, Estimator estimator) {
        this.checkLowHigh(low, high);
        return this.getSnapshotGraph(new Interval(low, high), Estimator.FIRST);
    }

    @Override
    public Graph getSnapshotGraph(Interval interval, Estimator estimator) {
        TimeInterval ti;
        Graph graph = this.model.getGraph(this.sourceView);
        Graph vgraph = this.model.getGraph(this.currentView);
        for (Node n : graph.getNodes().toArray()) {
            ti = (TimeInterval)n.getNodeData().getAttributes().getValue("time_interval");
            if (ti == null && !vgraph.contains(n)) {
                vgraph.addNode(n);
                continue;
            }
            if (ti != null && ti.getValue(interval, estimator) == null && vgraph.contains(n)) {
                vgraph.removeNode(n);
                continue;
            }
            if (ti == null || ti.getValue(interval, estimator) == null || vgraph.contains(n)) continue;
            vgraph.addNode(n);
        }
        for (Edge e : graph.getEdges().toArray()) {
            ti = (TimeInterval)e.getEdgeData().getAttributes().getValue("time_interval");
            if (ti == null && !vgraph.contains(e) && vgraph.contains(e.getSource()) && vgraph.contains(e.getTarget())) {
                vgraph.addEdge(e);
                continue;
            }
            if (ti != null && ti.getValue(interval, estimator) == null && vgraph.contains(e)) {
                vgraph.removeEdge(e);
                continue;
            }
            if (ti == null || ti.getValue(interval, estimator) == null || vgraph.contains(e) || !vgraph.contains(e.getSource()) || !vgraph.contains(e.getTarget())) continue;
            vgraph.addEdge(e);
        }
        return vgraph;
    }

    @Override
    public Graph getStrongSnapshotGraph(double point) {
        this.checkPoint(point);
        return this.getStrongSnapshotGraph(point, point);
    }

    @Override
    public Graph getStrongSnapshotGraph(double low, double high) {
        this.checkLowHigh(low, high);
        return this.getStrongSnapshotGraph(new Interval(low, high));
    }

    @Override
    public Graph getStrongSnapshotGraph(Interval interval) {
        TimeInterval ti;
        Graph graph = this.model.getGraph(this.sourceView);
        Graph vgraph = this.model.getGraph(this.currentView);
        for (Node n : graph.getNodes().toArray()) {
            ti = (TimeInterval)n.getNodeData().getAttributes().getValue("time_interval");
            if (ti.getValues(interval).size() < ti.getValues().size() && vgraph.contains(n)) {
                vgraph.removeNode(n);
                continue;
            }
            if (ti.getValues(interval).size() != ti.getValues().size() || vgraph.contains(n)) continue;
            vgraph.addNode(n);
        }
        for (Edge e : graph.getEdges().toArray()) {
            ti = (TimeInterval)e.getEdgeData().getAttributes().getValue("time_interval");
            if (ti.getValues(interval).size() < ti.getValues().size() && vgraph.contains(e)) {
                vgraph.removeEdge(e);
                continue;
            }
            if (ti.getValues(interval).size() != ti.getValues().size() || vgraph.contains(e) || !vgraph.contains(e.getSource()) || !vgraph.contains(e.getTarget())) continue;
            vgraph.addEdge(e);
        }
        return vgraph;
    }

    @Override
    public Graph getUnderlyingGraph() {
        return this.model.getGraph();
    }

    @Override
    public TimeInterval getInterval() {
        return new TimeInterval(this.low, this.high);
    }

    @Override
    public void setInterval(TimeInterval interval) {
        this.setInterval(interval.getLow(), interval.getHigh());
    }

    @Override
    public void setInterval(double low, double high) {
        if (low > high) {
            throw new IllegalArgumentException("The left endpoint of the interval must be less than the right endpoint.");
        }
        this.low = low;
        this.high = high;
    }

    private void checkPoint(double point) {
        if (point < this.low || point > this.high) {
            throw new IllegalArgumentException("The point cannot be out of range wrapped by this DynamicGraph");
        }
    }

    private void checkLowHigh(double low, double high) {
        if (low > high) {
            throw new IllegalArgumentException("The left endpoint of the interval must be less than the right endpoint.");
        }
        if (high < this.low || low > this.high) {
            throw new IllegalArgumentException("The time interval [low, high] cannot be out of range wrapped by this DynamicGraph");
        }
    }

    private void checkEstimators(Node node, Estimator[] estimators) {
        int count = node.getNodeData().getAttributes().countValues();
        if (count != estimators.length) {
            throw new IllegalArgumentException("The length of the estimators table must be the same as the count of attributes.");
        }
    }

    private void checkEstimators(Edge edge, Estimator[] estimators) {
        int count = edge.getEdgeData().getAttributes().countValues();
        if (count != estimators.length) {
            throw new IllegalArgumentException("The length of the estimators table must be the same as the count of attributes.");
        }
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass()) && ((DynamicGraphImpl)obj).model.getGraph().equals(this.model.getGraph());
    }

    public int hashCode() {
        return this.model.getGraph().hashCode();
    }

    public String toString() {
        return this.model.getGraph().toString();
    }
}

