/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.dynamic;

import java.util.TreeMap;
import org.gephi.data.attributes.type.Interval;
import org.gephi.dynamic.DynamicModelImpl;
import org.gephi.dynamic.api.DynamicModelEvent;

public class DynamicIndex {
    protected final TreeMap<Double, Integer> lowMap;
    protected final TreeMap<Double, Integer> highMap;
    protected final DynamicModelImpl model;

    public DynamicIndex(DynamicModelImpl model) {
        this.model = model;
        this.lowMap = new TreeMap();
        this.highMap = new TreeMap();
    }

    public synchronized void add(Interval interval) {
        Integer counter;
        Double low = interval.getLow();
        Double high = interval.getHigh();
        if (!Double.isInfinite(low)) {
            if (this.lowMap.get(low) != null) {
                counter = new Integer(this.lowMap.get(low) + 1);
                this.lowMap.put(low, counter);
            } else {
                Double min = this.lowMap.isEmpty() ? Double.POSITIVE_INFINITY : this.lowMap.firstKey();
                this.lowMap.put(low, 1);
                if (low < min) {
                    this.fireEvent(new DynamicModelEvent(DynamicModelEvent.EventType.MIN_CHANGED, this.model, low));
                }
            }
        }
        if (!Double.isInfinite(high)) {
            if (this.highMap.get(high) != null) {
                counter = new Integer(this.highMap.get(high) + 1);
                this.highMap.put(high, counter);
            } else {
                Double max = this.highMap.isEmpty() ? Double.NEGATIVE_INFINITY : this.highMap.lastKey();
                this.highMap.put(high, 1);
                if (high > max) {
                    this.fireEvent(new DynamicModelEvent(DynamicModelEvent.EventType.MAX_CHANGED, this.model, high));
                }
            }
        }
    }

    public synchronized void remove(Interval interval) {
        Integer counter;
        Double low = interval.getLow();
        Double high = interval.getHigh();
        if (!Double.isInfinite(low) && this.lowMap.get(low) != null) {
            counter = new Integer(this.lowMap.get(low) - 1);
            if (counter == 0) {
                Double min = this.lowMap.firstKey();
                this.lowMap.remove(low);
                if (min.equals(low)) {
                    this.fireEvent(new DynamicModelEvent(DynamicModelEvent.EventType.MIN_CHANGED, this.model, this.getMin()));
                }
            } else {
                this.lowMap.put(low, counter);
            }
        }
        if (!Double.isInfinite(high) && this.highMap.get(high) != null) {
            counter = new Integer(this.highMap.get(high) - 1);
            if (counter == 0) {
                Double max = this.highMap.lastKey();
                this.highMap.remove(high);
                if (max.equals(high)) {
                    this.fireEvent(new DynamicModelEvent(DynamicModelEvent.EventType.MAX_CHANGED, this.model, this.getMax()));
                }
            } else {
                this.highMap.put(high, counter);
            }
        }
    }

    public synchronized void clear() {
        this.lowMap.clear();
        this.highMap.clear();
    }

    public synchronized double getMin() {
        return this.lowMap.isEmpty() ? (this.highMap.isEmpty() ? Double.NEGATIVE_INFINITY : this.highMap.firstKey()) : this.lowMap.firstKey();
    }

    public synchronized double getMax() {
        return this.highMap.isEmpty() ? (this.lowMap.isEmpty() ? Double.POSITIVE_INFINITY : this.lowMap.lastKey()) : this.highMap.lastKey();
    }

    private void fireEvent(DynamicModelEvent event) {
        if (this.model != null) {
            this.model.controller.fireModelEvent(event);
        }
    }
}

