/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.dynamic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeEvent;
import org.gephi.data.attributes.api.AttributeListener;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeUtils;
import org.gephi.data.attributes.api.AttributeValue;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.Interval;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.dynamic.DynamicControllerImpl;
import org.gephi.dynamic.DynamicGraphImpl;
import org.gephi.dynamic.DynamicIndex;
import org.gephi.dynamic.api.DynamicGraph;
import org.gephi.dynamic.api.DynamicModel;
import org.gephi.dynamic.api.DynamicModelEvent;
import org.gephi.filters.api.FilterController;
import org.gephi.filters.api.FilterModel;
import org.gephi.filters.api.Query;
import org.gephi.filters.plugin.dynamic.DynamicRangeBuilder;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.graph.api.Attributes;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphEvent;
import org.gephi.graph.api.GraphListener;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;

public final class DynamicModelImpl
implements DynamicModel {
    protected final DynamicControllerImpl controller;
    private final FilterController filterController;
    private final DynamicIndex timeIntervalIndex;
    private final GraphModel graphModel;
    private final AttributeModel attributeModel;
    private final FilterModel filterModel;
    private final List<AttributeColumn> nodeDynamicColumns;
    private final List<AttributeColumn> edgeDynamicColumns;
    private TimeInterval visibleTimeInterval;
    private DynamicModel.TimeFormat timeFormat;
    private Estimator estimator = Estimator.FIRST;
    private Estimator numberEstimator = Estimator.AVERAGE;

    public DynamicModelImpl(DynamicControllerImpl controller, Workspace workspace) {
        this(controller, workspace, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public DynamicModelImpl(DynamicControllerImpl controller, Workspace workspace, double low, double high) {
        if (workspace == null) {
            throw new NullPointerException("The workspace cannot be null.");
        }
        this.timeFormat = DynamicModel.TimeFormat.DOUBLE;
        this.controller = controller;
        this.graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel(workspace);
        if (this.graphModel == null || this.graphModel.getGraph() == null) {
            throw new NullPointerException("The graph model and its underlying graph cannot be nulls.");
        }
        this.filterController = (FilterController)Lookup.getDefault().lookup(FilterController.class);
        this.filterModel = this.filterController.getModel(workspace);
        if (this.filterModel == null) {
            throw new NullPointerException("The filter model.");
        }
        this.timeIntervalIndex = new DynamicIndex(this);
        this.attributeModel = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel(workspace);
        this.nodeDynamicColumns = Collections.synchronizedList(new ArrayList());
        this.edgeDynamicColumns = Collections.synchronizedList(new ArrayList());
        this.refresh();
        this.visibleTimeInterval = new TimeInterval(this.timeIntervalIndex.getMin(), this.timeIntervalIndex.getMax());
        final AttributeUtils attUtils = AttributeUtils.getDefault();
        AttributeListener attributeListener = new AttributeListener(){

            @Override
            public void attributesChanged(AttributeEvent event) {
                switch (event.getEventType()) {
                    case ADD_COLUMN: {
                        AttributeColumn[] addedColumns = event.getData().getAddedColumns();
                        for (int i = 0; i < addedColumns.length; ++i) {
                            AttributeColumn col = addedColumns[i];
                            if (col.getType().isDynamicType() && attUtils.isNodeColumn(col)) {
                                DynamicModelImpl.this.nodeDynamicColumns.add(col);
                                continue;
                            }
                            if (!col.getType().isDynamicType() || !attUtils.isEdgeColumn(col)) continue;
                            DynamicModelImpl.this.edgeDynamicColumns.add(col);
                        }
                        break;
                    }
                    case REMOVE_COLUMN: {
                        AttributeColumn[] removedColumns = event.getData().getRemovedColumns();
                        for (int i = 0; i < removedColumns.length; ++i) {
                            AttributeColumn col = removedColumns[i];
                            if (col.getType().isDynamicType() && attUtils.isNodeColumn(col)) {
                                DynamicModelImpl.this.nodeDynamicColumns.remove(col);
                                continue;
                            }
                            if (!col.getType().isDynamicType() || !attUtils.isEdgeColumn(col)) continue;
                            DynamicModelImpl.this.edgeDynamicColumns.remove(col);
                        }
                        break;
                    }
                    case SET_VALUE: {
                        AttributeValue[] values = event.getData().getTouchedValues();
                        for (int i = 0; i < values.length; ++i) {
                            AttributeColumn col;
                            AttributeValue val = values[i];
                            if (val.getValue() == null || !(col = values[i].getColumn()).getType().isDynamicType()) continue;
                            DynamicType dynamicType = (DynamicType)val.getValue();
                            for (Interval interval : dynamicType.getIntervals(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)) {
                                DynamicModelImpl.this.timeIntervalIndex.add(interval);
                            }
                        }
                        break;
                    }
                }
            }
        };
        this.attributeModel.addAttributeListener(attributeListener);
        GraphListener graphListener = new GraphListener(){

            @Override
            public void graphChanged(GraphEvent event) {
                if (event.getSource().isMainView()) {
                    switch (event.getEventType()) {
                        case REMOVE_EDGES: {
                            if (DynamicModelImpl.this.edgeDynamicColumns.isEmpty()) break;
                            AttributeColumn[] dynamicCols = DynamicModelImpl.this.edgeDynamicColumns.toArray(new AttributeColumn[0]);
                            for (Edge e : event.getData().removedEdges()) {
                                Attributes attributeRow = e.getEdgeData().getAttributes();
                                for (int i = 0; i < dynamicCols.length; ++i) {
                                    DynamicType ti = (DynamicType)attributeRow.getValue(dynamicCols[i].getIndex());
                                    if (ti == null) continue;
                                    for (Interval interval : ti.getIntervals(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)) {
                                        DynamicModelImpl.this.timeIntervalIndex.remove(interval);
                                    }
                                }
                            }
                            break;
                        }
                        case REMOVE_NODES: {
                            if (DynamicModelImpl.this.nodeDynamicColumns.isEmpty()) break;
                            AttributeColumn[] dynamicCols = DynamicModelImpl.this.edgeDynamicColumns.toArray(new AttributeColumn[0]);
                            for (Node n : event.getData().removedNodes()) {
                                Attributes attributeRow = n.getNodeData().getAttributes();
                                for (int i = 0; i < dynamicCols.length; ++i) {
                                    DynamicType ti = (DynamicType)attributeRow.getValue(dynamicCols[i].getIndex());
                                    if (ti == null) continue;
                                    for (Interval interval : ti.getIntervals(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)) {
                                        DynamicModelImpl.this.timeIntervalIndex.remove(interval);
                                    }
                                }
                            }
                            break;
                        }
                    }
                }
            }
        };
        this.graphModel.addGraphListener(graphListener);
    }

    private void refresh() {
        DynamicType ti;
        int i;
        Attributes attributeRow;
        this.timeIntervalIndex.clear();
        for (AttributeColumn col : this.attributeModel.getNodeTable().getColumns()) {
            if (!col.getType().isDynamicType()) continue;
            this.nodeDynamicColumns.add(col);
        }
        AttributeColumn[] dynamicCols = this.nodeDynamicColumns.toArray(new AttributeColumn[0]);
        if (dynamicCols.length > 0) {
            Graph graph = this.graphModel.getGraph();
            for (Node n : graph.getNodes()) {
                attributeRow = n.getNodeData().getAttributes();
                for (i = 0; i < dynamicCols.length; ++i) {
                    ti = (DynamicType)attributeRow.getValue(dynamicCols[i].getIndex());
                    if (ti == null) continue;
                    for (Interval interval : ti.getIntervals(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)) {
                        this.timeIntervalIndex.add(interval);
                    }
                }
            }
        }
        for (AttributeColumn col : this.attributeModel.getNodeTable().getColumns()) {
            if (!col.getType().isDynamicType()) continue;
            this.edgeDynamicColumns.add(col);
        }
        dynamicCols = this.nodeDynamicColumns.toArray(new AttributeColumn[0]);
        if (dynamicCols.length > 0) {
            Graph graph = this.graphModel.getGraph();
            for (Edge e : graph.getEdges()) {
                attributeRow = e.getEdgeData().getAttributes();
                for (i = 0; i < dynamicCols.length; ++i) {
                    ti = (DynamicType)attributeRow.getValue(dynamicCols[i].getIndex());
                    if (ti == null) continue;
                    for (Interval interval : ti.getIntervals(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)) {
                        this.timeIntervalIndex.add(interval);
                    }
                }
            }
        }
    }

    @Override
    public DynamicGraph createDynamicGraph(Graph graph) {
        return new DynamicGraphImpl(graph);
    }

    @Override
    public DynamicGraph createDynamicGraph(Graph graph, TimeInterval interval) {
        return new DynamicGraphImpl(graph, interval.getLow(), interval.getHigh());
    }

    @Override
    public TimeInterval getVisibleInterval() {
        return this.visibleTimeInterval;
    }

    public void setVisibleTimeInterval(TimeInterval visibleTimeInterval) {
        if (!(Double.isNaN(visibleTimeInterval.getLow()) || Double.isNaN(visibleTimeInterval.getHigh()) || this.visibleTimeInterval.equals(visibleTimeInterval))) {
            Query[] dynamicQueries;
            Query query;
            this.visibleTimeInterval = visibleTimeInterval;
            Query dynamicQuery = null;
            boolean selecting = false;
            if (this.filterModel.getCurrentQuery() != null) {
                query = this.filterModel.getCurrentQuery();
                dynamicQueries = query.getQueries(DynamicRangeBuilder.DynamicRangeFilter.class);
                if (dynamicQueries.length > 0) {
                    dynamicQuery = query;
                    selecting = this.filterModel.isSelecting();
                }
            } else if (this.filterModel.getQueries().length == 1 && (dynamicQueries = (query = this.filterModel.getQueries()[0]).getQueries(DynamicRangeBuilder.DynamicRangeFilter.class)).length > 0) {
                dynamicQuery = query;
            }
            if (Double.isInfinite(visibleTimeInterval.getLow()) && Double.isInfinite(visibleTimeInterval.getHigh())) {
                if (dynamicQuery != null) {
                    this.filterController.remove(dynamicQuery);
                }
            } else {
                DynamicRangeBuilder rangeBuilder;
                FilterBuilder[] fb;
                if (dynamicQuery == null && (fb = (rangeBuilder = (DynamicRangeBuilder)this.filterModel.getLibrary().getLookup().lookup(DynamicRangeBuilder.class)).getBuilders()).length > 0) {
                    DynamicRangeBuilder.DynamicRangeFilter filter = (DynamicRangeBuilder.DynamicRangeFilter)fb[0].getFilter();
                    dynamicQuery = this.filterController.createQuery(filter);
                    this.filterController.add(dynamicQuery);
                }
                if (dynamicQuery != null) {
                    if (selecting) {
                        this.filterController.selectVisible(dynamicQuery);
                    } else {
                        this.filterController.filterVisible(dynamicQuery);
                    }
                }
            }
            this.controller.fireModelEvent(new DynamicModelEvent(DynamicModelEvent.EventType.VISIBLE_INTERVAL, this, visibleTimeInterval));
        }
    }

    @Override
    public boolean isDynamicGraph() {
        return !Double.isInfinite(this.timeIntervalIndex.getMax()) || !Double.isInfinite(this.timeIntervalIndex.getMin());
    }

    @Override
    public DynamicModel.TimeFormat getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(DynamicModel.TimeFormat timeFormat) {
        this.timeFormat = timeFormat;
    }

    @Override
    public double getMin() {
        return this.timeIntervalIndex.getMin();
    }

    @Override
    public double getMax() {
        return this.timeIntervalIndex.getMax();
    }

    @Override
    public Estimator getEstimator() {
        return this.estimator;
    }

    @Override
    public Estimator getNumberEstimator() {
        return this.numberEstimator;
    }

    public void setEstimator(Estimator estimator) {
        this.estimator = estimator;
    }

    public void setNumberEstimator(Estimator numberEstimator) {
        this.numberEstimator = numberEstimator;
    }
}

