/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.dynamic;

import org.gephi.dynamic.DynamicControllerImpl;
import org.gephi.dynamic.DynamicModelImpl;
import org.gephi.dynamic.api.DynamicController;
import org.gephi.dynamic.api.DynamicModel;
import org.gephi.project.api.Workspace;
import org.gephi.project.spi.WorkspacePersistenceProvider;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DynamicModelPersistenceProvider
implements WorkspacePersistenceProvider {
    @Override
    public Element writeXML(Document document, Workspace workspace) {
        DynamicModelImpl model = (DynamicModelImpl)workspace.getLookup().lookup(DynamicModel.class);
        if (model != null) {
            return this.writeModel(document, model);
        }
        return null;
    }

    @Override
    public void readXML(Element element, Workspace workspace) {
        DynamicControllerImpl dynamicController = (DynamicControllerImpl)Lookup.getDefault().lookup(DynamicController.class);
        DynamicModelImpl dynamicModelImpl = new DynamicModelImpl(dynamicController, workspace);
        this.readModel(element, dynamicModelImpl);
        workspace.add(dynamicModelImpl);
    }

    @Override
    public String getIdentifier() {
        return "dynamicmodel";
    }

    public Element writeModel(Document document, DynamicModelImpl model) {
        Element modelE = document.createElement("dynamicmodel");
        Element timeFormatE = document.createElement("timeformat");
        if (model.getTimeFormat().equals((Object)DynamicModel.TimeFormat.DATE)) {
            timeFormatE.setAttribute("value", "date");
        } else {
            timeFormatE.setAttribute("value", "double");
        }
        modelE.appendChild(timeFormatE);
        return modelE;
    }

    public void readModel(Element modelE, DynamicModelImpl model) {
        NodeList modelListE = modelE.getChildNodes();
        for (int i = 0; i < modelListE.getLength(); ++i) {
            Element itemE;
            if (modelListE.item(i).getNodeType() != 1 || !(itemE = (Element)modelListE.item(i)).getTagName().equals("timeformat")) continue;
            String val = itemE.getAttribute("value");
            if (val.equals("date")) {
                model.setTimeFormat(DynamicModel.TimeFormat.DATE);
                continue;
            }
            model.setTimeFormat(DynamicModel.TimeFormat.DOUBLE);
        }
    }
}

