/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters;

import java.beans.PropertyEditorSupport;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeType;
import org.openide.util.Lookup;

public class AttributeColumnPropertyEditor
extends PropertyEditorSupport {
    private AttributeColumn column;

    public void setValue(Object value) {
        this.column = this.column;
    }

    public Object getValue() {
        return this.column;
    }

    public String getAsText() {
        if (this.column != null) {
            AttributeModel model = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel();
            if (model.getNodeTable().hasColumn(this.column.getTitle())) {
                return "NODE*-*" + this.column.getId() + "*-*" + this.column.getType().toString();
            }
            if (model.getEdgeTable().hasColumn(this.column.getTitle())) {
                return "EDGE*-*" + this.column.getId() + "*-*" + this.column.getType().toString();
            }
        }
        return "null";
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (!text.equals("null")) {
            AttributeModel model = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel();
            String[] arr = text.split(" - ");
            if (arr[0].equals("NODE")) {
                this.column = model.getNodeTable().getColumn(arr[1], AttributeType.valueOf(arr[2]));
            } else if (arr[0].equals("EDGE")) {
                this.column = model.getEdgeTable().getColumn(arr[1], AttributeType.valueOf(arr[2]));
            }
        }
    }
}

