/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters;

import java.util.concurrent.atomic.AtomicBoolean;
import org.gephi.filters.AbstractQueryImpl;
import org.gephi.filters.FilterModelImpl;
import org.gephi.graph.api.GraphEvent;
import org.gephi.graph.api.GraphListener;
import org.gephi.graph.api.GraphModel;
import org.openide.util.Exceptions;

public class FilterAutoRefreshor
extends Thread
implements GraphListener {
    private static final int TIMER = 1000;
    private final GraphModel graphModel;
    private final FilterModelImpl filterModel;
    private boolean running = true;
    private AtomicBoolean refresh = new AtomicBoolean(false);

    public FilterAutoRefreshor(FilterModelImpl filterModel, GraphModel graphModel) {
        super("Filter Auto-Refresh");
        this.setDaemon(true);
        this.graphModel = graphModel;
        this.filterModel = filterModel;
    }

    public void run() {
        while (this.running) {
            try {
                if (this.refresh.compareAndSet(true, false)) {
                    this.manualRefresh();
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void setEnable(boolean enable) {
        if (enable) {
            this.graphModel.addGraphListener(this);
        } else {
            this.graphModel.removeGraphListener(this);
            this.refresh.set(false);
        }
        if (!this.isAlive()) {
            this.start();
        }
    }

    public void graphChanged(GraphEvent event) {
        if (event.getSource().isMainView() && event.is(GraphEvent.EventType.ADD_EDGES, GraphEvent.EventType.ADD_NODES, GraphEvent.EventType.MOVE_NODES, GraphEvent.EventType.REMOVE_EDGES, GraphEvent.EventType.REMOVE_NODES)) {
            this.refresh.set(true);
        }
    }

    public void setRunning(boolean running) {
        this.running = running;
        if (!running) {
            this.graphModel.removeGraphListener(this);
            this.refresh.set(false);
        }
    }

    public void manualRefresh() {
        if (this.filterModel.getFilterThread() != null && this.filterModel.getCurrentQuery() != null) {
            this.filterModel.getFilterThread().setRootQuery((AbstractQueryImpl)this.filterModel.getCurrentQuery());
        }
    }
}

