/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters;

import java.beans.PropertyEditorManager;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.filters.AbstractQueryImpl;
import org.gephi.filters.AttributeColumnPropertyEditor;
import org.gephi.filters.FilterModelImpl;
import org.gephi.filters.FilterProcessor;
import org.gephi.filters.FilterQueryImpl;
import org.gephi.filters.FilterThread;
import org.gephi.filters.OperatorQueryImpl;
import org.gephi.filters.RangePropertyEditor;
import org.gephi.filters.api.FilterController;
import org.gephi.filters.api.FilterModel;
import org.gephi.filters.api.PropertyExecutor;
import org.gephi.filters.api.Query;
import org.gephi.filters.api.Range;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.Operator;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceInformation;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.gephi.utils.progress.ProgressTicketProvider;
import org.gephi.visualization.api.VisualizationController;
import org.openide.util.Lookup;

public class FilterControllerImpl
implements FilterController,
PropertyExecutor {
    private FilterModelImpl model;

    public FilterControllerImpl() {
        PropertyEditorManager.registerEditor(Range.class, RangePropertyEditor.class);
        PropertyEditorManager.registerEditor(AttributeColumn.class, AttributeColumnPropertyEditor.class);
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        pc.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
                workspace.add(new FilterModelImpl(workspace));
            }

            public void select(Workspace workspace) {
                FilterControllerImpl.this.model = (FilterModelImpl)workspace.getLookup().lookup(FilterModel.class);
                if (FilterControllerImpl.this.model == null) {
                    FilterControllerImpl.this.model = new FilterModelImpl(workspace);
                    workspace.add(FilterControllerImpl.this.model);
                }
            }

            public void unselect(Workspace workspace) {
            }

            public void close(Workspace workspace) {
                FilterModelImpl m = (FilterModelImpl)workspace.getLookup().lookup(FilterModel.class);
                if (m != null) {
                    m.destroy();
                }
            }

            public void disable() {
                GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
                if (FilterControllerImpl.this.model.getCurrentResult() != null && graphModel != null) {
                    graphModel.destroyView(FilterControllerImpl.this.model.getCurrentResult());
                    FilterControllerImpl.this.model.setCurrentResult(null);
                }
                FilterControllerImpl.this.model = null;
            }
        });
        if (pc.getCurrentWorkspace() != null) {
            Workspace workspace = pc.getCurrentWorkspace();
            this.model = (FilterModelImpl)workspace.getLookup().lookup(FilterModel.class);
            if (this.model == null) {
                this.model = new FilterModelImpl(workspace);
                workspace.add(this.model);
            }
        }
    }

    public Query createQuery(Filter filter) {
        if (filter instanceof Operator) {
            return new OperatorQueryImpl((Operator)filter);
        }
        return new FilterQueryImpl(filter);
    }

    public void add(Query query) {
        if (!this.model.hasQuery(query = ((AbstractQueryImpl)query).getRoot())) {
            this.model.addFirst(query);
        }
    }

    public void remove(Query query) {
        if (this.model.getCurrentQuery() == query) {
            if (this.model.isSelecting()) {
                this.selectVisible(null);
            } else {
                this.filterVisible(null);
            }
        }
        query = ((AbstractQueryImpl)query).getRoot();
        this.model.remove(query);
    }

    public void rename(Query query, String name) {
        this.model.rename(query, name);
    }

    public void setSubQuery(Query query, Query subQuery) {
        this.model.setSubQuery(query, subQuery);
    }

    public void removeSubQuery(Query query, Query parent) {
        this.model.removeSubQuery(query, parent);
    }

    public void filterVisible(Query query) {
        if (query != null && this.model.getCurrentQuery() == query && this.model.isFiltering()) {
            return;
        }
        this.model.setFiltering(true);
        this.model.setCurrentQuery(query);
        if (this.model.getFilterThread() != null) {
            this.model.getFilterThread().setRunning(false);
            this.model.setFilterThread(null);
        }
        if (query != null) {
            FilterThread filterThread = new FilterThread(this.model);
            this.model.setFilterThread(filterThread);
            filterThread.setRootQuery((AbstractQueryImpl)query);
            filterThread.start();
        } else {
            GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
            graphModel.setVisibleView(null);
            if (this.model.getCurrentResult() != null) {
                graphModel.destroyView(this.model.getCurrentResult());
                this.model.setCurrentResult(null);
            }
        }
    }

    public GraphView filter(Query query) {
        FilterProcessor processor = new FilterProcessor();
        GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
        Graph result = processor.process((AbstractQueryImpl)query, graphModel);
        return result.getView();
    }

    public void selectVisible(Query query) {
        if (query != null && this.model.getCurrentQuery() == query && !this.model.isFiltering()) {
            return;
        }
        this.model.setFiltering(false);
        this.model.setCurrentQuery(query);
        if (this.model.getFilterThread() != null) {
            this.model.getFilterThread().setRunning(false);
            this.model.setFilterThread(null);
        }
        GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
        graphModel.setVisibleView(null);
        if (this.model.getCurrentResult() != null) {
            graphModel.destroyView(this.model.getCurrentResult());
            this.model.setCurrentResult(null);
        }
        if (query != null) {
            FilterThread filterThread = new FilterThread(this.model);
            this.model.setFilterThread(filterThread);
            filterThread.setRootQuery((AbstractQueryImpl)query);
            filterThread.start();
        } else {
            VisualizationController visController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
            if (visController != null) {
                visController.selectNodes(null);
            }
        }
    }

    public void exportToColumn(String title, Query query) {
        AttributeColumn edgeCol;
        HierarchicalGraph result;
        if (this.model.getCurrentQuery() == query) {
            GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
            GraphView view = this.model.getCurrentResult();
            if (view != null) {
                return;
            }
            result = graphModel.getHierarchicalGraph(view);
        } else {
            FilterProcessor processor = new FilterProcessor();
            GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
            result = (HierarchicalGraph)processor.process((AbstractQueryImpl)query, graphModel);
        }
        AttributeModel am = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel();
        AttributeColumn nodeCol = am.getNodeTable().getColumn("filter_" + title);
        if (nodeCol == null) {
            nodeCol = am.getNodeTable().addColumn("filter_" + title, title, AttributeType.BOOLEAN, AttributeOrigin.COMPUTED, (Object)Boolean.FALSE);
        }
        if ((edgeCol = am.getEdgeTable().getColumn("filter_" + title)) == null) {
            edgeCol = am.getEdgeTable().addColumn("filter_" + title, title, AttributeType.BOOLEAN, AttributeOrigin.COMPUTED, (Object)Boolean.FALSE);
        }
        result.readLock();
        for (Node n : result.getNodes()) {
            n.getNodeData().getAttributes().setValue(nodeCol.getIndex(), (Object)Boolean.TRUE);
        }
        for (Edge e : result.getEdgesAndMetaEdges()) {
            e.getEdgeData().getAttributes().setValue(edgeCol.getIndex(), (Object)Boolean.TRUE);
        }
        result.readUnlock();
    }

    public void exportToNewWorkspace(Query query) {
        HierarchicalGraph result;
        if (this.model.getCurrentQuery() == query) {
            GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
            GraphView view = this.model.getCurrentResult();
            if (view == null) {
                return;
            }
            result = graphModel.getHierarchicalGraph(view);
        } else {
            FilterProcessor processor = new FilterProcessor();
            GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
            result = (HierarchicalGraph)processor.process((AbstractQueryImpl)query, graphModel);
        }
        final HierarchicalGraph graphView = result;
        new Thread(new Runnable(){

            public void run() {
                ProgressTicketProvider progressProvider = (ProgressTicketProvider)Lookup.getDefault().lookup(ProgressTicketProvider.class);
                ProgressTicket ticket = null;
                if (progressProvider != null) {
                    ticket = progressProvider.createTicket("Export to workspace", null);
                }
                Progress.start(ticket);
                ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
                Workspace newWorkspace = pc.duplicateWorkspace(pc.getCurrentWorkspace());
                GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel(newWorkspace);
                graphModel.clear();
                graphModel.pushFrom(graphView);
                Progress.finish(ticket);
                String workspaceName = ((WorkspaceInformation)newWorkspace.getLookup().lookup(WorkspaceInformation.class)).getName();
            }
        }, "Export filter to workspace").start();
    }

    public void exportToLabelVisible(Query query) {
        boolean inView;
        HierarchicalGraph result;
        GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
        if (this.model.getCurrentQuery() == query) {
            GraphView view = this.model.getCurrentResult();
            if (view == null) {
                return;
            }
            result = graphModel.getHierarchicalGraph(view);
        } else {
            FilterProcessor processor = new FilterProcessor();
            result = (HierarchicalGraph)processor.process((AbstractQueryImpl)query, graphModel);
        }
        HierarchicalGraph fullHGraph = graphModel.getHierarchicalGraph();
        fullHGraph.readLock();
        for (Node n : fullHGraph.getNodes()) {
            inView = n.getNodeData().getNode(result.getView().getViewId()) != null;
            n.getNodeData().getTextData().setVisible(inView);
        }
        for (Edge e : fullHGraph.getEdgesAndMetaEdges()) {
            inView = result.contains(e);
            e.getEdgeData().getTextData().setVisible(inView);
        }
        fullHGraph.readUnlock();
    }

    public void setAutoRefresh(boolean autoRefresh) {
        if (this.model != null) {
            this.model.setAutoRefresh(autoRefresh);
        }
    }

    public FilterModel getModel() {
        return this.model;
    }

    public synchronized FilterModel getModel(Workspace workspace) {
        FilterModel filterModel = (FilterModel)workspace.getLookup().lookup(FilterModel.class);
        if (filterModel == null) {
            filterModel = new FilterModelImpl(workspace);
            workspace.add(filterModel);
        }
        return filterModel;
    }

    public void setValue(FilterProperty property, Object value, PropertyExecutor.Callback callback) {
        if (this.model != null) {
            Query query = this.model.getQuery(property.getFilter());
            if (query == null) {
                callback.setValue(value);
                return;
            }
            AbstractQueryImpl rootQuery = ((AbstractQueryImpl)query).getRoot();
            FilterThread filterThread = null;
            filterThread = this.model.getFilterThread();
            if (filterThread != null && this.model.getCurrentQuery() == rootQuery) {
                filterThread.addModifier(new FilterThread.PropertyModifier(query, property, value, callback));
                filterThread.setRootQuery(rootQuery);
            } else {
                callback.setValue(value);
                this.model.updateParameters(query);
            }
        } else {
            callback.setValue(value);
        }
    }
}

