/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters;

import java.util.HashMap;
import java.util.Map;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.api.Query;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterLibraryMask;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class FilterLibraryImpl
implements FilterLibrary {
    private AbstractLookup lookup;
    private InstanceContent content = new InstanceContent();
    private Map<Class<? extends Filter>, FilterBuilder> buildersMap;

    public FilterLibraryImpl() {
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.content);
        for (FilterBuilder builder : Lookup.getDefault().lookupAll(FilterBuilder.class)) {
            this.content.add((Object)builder);
        }
        for (Query query : Lookup.getDefault().lookupAll(Query.class)) {
            this.content.add((Object)query);
        }
        for (CategoryBuilder catBuilder : Lookup.getDefault().lookupAll(CategoryBuilder.class)) {
            this.content.add((Object)catBuilder);
        }
        this.content.add((Object)new HierarchicalGraphMask());
    }

    private void buildBuildersMap() {
        this.buildersMap = new HashMap<Class<? extends Filter>, FilterBuilder>();
        for (FilterBuilder builder : this.lookup.lookupAll(FilterBuilder.class)) {
            try {
                Filter f = builder.getFilter();
                this.buildersMap.put(f.getClass(), builder);
                builder.destroy(f);
            }
            catch (Exception e) {}
        }
        for (CategoryBuilder catBuilder : Lookup.getDefault().lookupAll(CategoryBuilder.class)) {
            for (FilterBuilder builder : catBuilder.getBuilders()) {
                try {
                    Filter f = builder.getFilter();
                    this.buildersMap.put(f.getClass(), builder);
                    builder.destroy(f);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public void addBuilder(FilterBuilder builder) {
        this.content.add((Object)builder);
    }

    public void removeBuilder(FilterBuilder builder) {
        this.content.remove((Object)builder);
    }

    public void registerMask(FilterLibraryMask mask) {
        this.content.add((Object)mask);
    }

    public void unregisterMask(FilterLibraryMask mask) {
        this.content.remove((Object)mask);
    }

    public FilterBuilder getBuilder(Filter filter) {
        if (this.buildersMap == null) {
            this.buildBuildersMap();
        }
        if (this.buildersMap.get(filter.getClass()) != null) {
            return this.buildersMap.get(filter.getClass());
        }
        this.buildBuildersMap();
        if (this.buildersMap.get(filter.getClass()) != null) {
            return this.buildersMap.get(filter.getClass());
        }
        return null;
    }

    public void saveQuery(Query query) {
        this.content.add((Object)query);
    }

    private static class HierarchicalGraphMask
    implements FilterLibraryMask {
        private HierarchicalGraphMask() {
        }

        public Category getCategory() {
            return FilterLibrary.HIERARCHY;
        }

        public boolean isValid() {
            GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
            return graphModel.isHierarchical();
        }
    }
}

