/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.filters.AbstractQueryImpl;
import org.gephi.filters.FilterAutoRefreshor;
import org.gephi.filters.FilterLibraryImpl;
import org.gephi.filters.FilterQueryImpl;
import org.gephi.filters.FilterThread;
import org.gephi.filters.api.FilterController;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.api.FilterModel;
import org.gephi.filters.api.Query;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FilterModelImpl
implements FilterModel {
    private FilterLibraryImpl filterLibraryImpl = new FilterLibraryImpl();
    private LinkedList<Query> queries = new LinkedList();
    private FilterThread filterThread;
    private Query currentQuery;
    private boolean filtering;
    private GraphView currentResult;
    private boolean autoRefresh = true;
    private FilterAutoRefreshor autoRefreshor;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private int queryId = 0;

    public FilterModelImpl(Workspace workspace) {
        GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel(workspace);
        this.autoRefreshor = new FilterAutoRefreshor(this, graphModel);
    }

    public FilterLibrary getLibrary() {
        return this.filterLibraryImpl;
    }

    public Query[] getQueries() {
        return this.queries.toArray(new Query[0]);
    }

    public boolean hasQuery(Query query) {
        for (Query q : this.getQueries()) {
            if (q != query) continue;
            return true;
        }
        return false;
    }

    public void addFirst(Query function) {
        this.queries.addFirst(function);
        this.fireChangeEvent();
    }

    public void addLast(Query function) {
        this.queries.addLast(function);
        this.fireChangeEvent();
    }

    public void set(int index, Query function) {
        this.queries.set(index, function);
    }

    public void remove(Query query) {
        this.queries.remove(query);
        this.destroyQuery(query);
        this.fireChangeEvent();
    }

    public void rename(Query query, String name) {
        ((AbstractQueryImpl)query).setName(name);
        this.fireChangeEvent();
    }

    public void setSubQuery(Query query, Query subQuery) {
        if (this.queries.contains(subQuery)) {
            this.queries.remove(subQuery);
        }
        if (subQuery.getParent() != null) {
            ((AbstractQueryImpl)subQuery.getParent()).removeSubQuery(subQuery);
        }
        AbstractQueryImpl impl = (AbstractQueryImpl)query;
        impl.addSubQuery(subQuery);
        this.fireChangeEvent();
        this.autoRefreshor.manualRefresh();
    }

    public void removeSubQuery(Query query, Query parent) {
        AbstractQueryImpl impl = (AbstractQueryImpl)parent;
        impl.removeSubQuery(query);
        ((AbstractQueryImpl)query).setParent(null);
        this.fireChangeEvent();
        this.autoRefreshor.manualRefresh();
    }

    public int getIndex(Query function) {
        int i = 0;
        for (Query f : this.queries) {
            if (f == function) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isFiltering() {
        return this.currentQuery != null && this.filtering;
    }

    public boolean isSelecting() {
        return this.currentQuery != null && !this.filtering;
    }

    public void setFiltering(boolean filtering) {
        this.filtering = filtering;
    }

    public void setSelecting(boolean selecting) {
        this.filtering = !selecting;
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
        this.fireChangeEvent();
        if (!autoRefresh) {
            this.autoRefreshor.setEnable(false);
        } else if (autoRefresh && this.currentResult != null) {
            this.autoRefreshor.setEnable(true);
        }
    }

    public Query getCurrentQuery() {
        return this.currentQuery;
    }

    public void setCurrentQuery(Query currentQuery) {
        this.currentQuery = currentQuery;
        this.fireChangeEvent();
    }

    public void updateParameters(Query query) {
        if (query instanceof FilterQueryImpl) {
            ((FilterQueryImpl)query).updateParameters();
            this.fireChangeEvent();
        }
    }

    public Query getQuery(Filter filter) {
        for (Query q : this.getAllQueries()) {
            if (filter != q.getFilter()) continue;
            return q;
        }
        return null;
    }

    public Query[] getAllQueries() {
        ArrayList<Query> result = new ArrayList<Query>();
        LinkedList<Query> stack = new LinkedList<Query>();
        stack.addAll(this.queries);
        while (!stack.isEmpty()) {
            Query q = (Query)stack.pop();
            result.add(q);
            for (Query child : q.getChildren()) {
                stack.add(child);
            }
        }
        return result.toArray(new Query[0]);
    }

    public FilterThread getFilterThread() {
        return this.filterThread;
    }

    public FilterAutoRefreshor getAutoRefreshor() {
        return this.autoRefreshor;
    }

    public void setFilterThread(FilterThread filterThread) {
        this.filterThread = filterThread;
    }

    public void setCurrentResult(GraphView currentResult) {
        this.currentResult = currentResult;
        if (currentResult != null && this.autoRefresh) {
            this.autoRefreshor.setEnable(true);
        } else if (currentResult == null && this.autoRefresh) {
            this.autoRefreshor.setEnable(false);
        }
    }

    public GraphView getCurrentResult() {
        return this.currentResult;
    }

    public void destroy() {
        if (this.filterThread != null) {
            this.filterThread.setRunning(false);
        }
        this.autoRefreshor.setRunning(false);
        this.currentResult = null;
        this.listeners = null;
        for (Query q : this.queries) {
            this.destroyQuery(q);
        }
    }

    private void destroyQuery(Query query) {
        if (query instanceof AbstractQueryImpl) {
            AbstractQueryImpl absQuery = (AbstractQueryImpl)query;
            for (Query q : absQuery.getDescendantsAndSelf()) {
                Filter f;
                FilterBuilder builder;
                if (!(q instanceof FilterQueryImpl) || (builder = this.filterLibraryImpl.getBuilder(f = ((FilterQueryImpl)q).getFilter())) == null) continue;
                builder.destroy(f);
            }
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private void fireChangeEvent() {
        ChangeEvent evt = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(evt);
        }
    }

    public Element writeXML(Document document) {
        Element filterModelE = document.createElement("filtermodel");
        filterModelE.setAttribute("autorefresh", String.valueOf(this.autoRefresh));
        Element queriesE = document.createElement("queries");
        this.queryId = 0;
        for (Query query : this.queries) {
            this.writeQuery(document, queriesE, query, -1);
        }
        filterModelE.appendChild(queriesE);
        return filterModelE;
    }

    private void writeQuery(Document document, Element parentElement, Query query, int parentId) {
        Element queryE = document.createElement("query");
        int id = this.queryId++;
        queryE.setAttribute("id", String.valueOf(id));
        if (parentId != -1) {
            queryE.setAttribute("parent", String.valueOf(parentId));
        }
        for (int i = 0; i < query.getPropertiesCount(); ++i) {
            FilterProperty prop = query.getFilter().getProperties()[i];
            Element paramE = this.writeParameter(document, i, prop);
            if (paramE == null) continue;
            queryE.appendChild(paramE);
        }
        FilterBuilder builder = this.filterLibraryImpl.getBuilder(query.getFilter());
        queryE.setAttribute("builder", builder.getClass().getName());
        parentElement.appendChild(queryE);
        for (Query child : query.getChildren()) {
            this.writeQuery(document, parentElement, child, id);
        }
    }

    private Element writeParameter(Document document, int index, FilterProperty property) {
        Element parameterE = document.createElement("parameter");
        parameterE.setAttribute("index", String.valueOf(index));
        try {
            PropertyEditor editor = property.getPropertyEditor();
            if (editor == null) {
                editor = PropertyEditorManager.findEditor(property.getValueType());
            }
            if (editor == null) {
                return null;
            }
            editor.setValue(property.getValue());
            parameterE.setTextContent(editor.getAsText());
            return parameterE;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void readXML(Element filterModelE) {
        String autofresh = filterModelE.getAttribute("autorefresh");
        if (autofresh != null && !autofresh.isEmpty()) {
            this.autoRefresh = Boolean.parseBoolean(autofresh);
        }
        this.queries.clear();
        HashMap<Integer, Query> idMap = new HashMap<Integer, Query>();
        NodeList queryList = filterModelE.getElementsByTagName("query");
        for (int i = 0; i < queryList.getLength(); ++i) {
            Element queryE;
            Query query;
            Node n = queryList.item(i);
            if (n.getNodeType() != 1 || (query = this.readQuery(queryE = (Element)n)) == null) continue;
            idMap.put(Integer.parseInt(queryE.getAttribute("id")), query);
            if (queryE.hasAttribute("parent")) {
                int parentId = Integer.parseInt(queryE.getAttribute("parent"));
                Query parentQuery = (Query)idMap.get(parentId);
                this.setSubQuery(parentQuery, query);
                continue;
            }
            this.addFirst(query);
        }
    }

    private Query readQuery(Element queryE) {
        String builderClassName = queryE.getAttribute("builder");
        FilterBuilder builder = null;
        for (FilterBuilder fb : this.filterLibraryImpl.getLookup().lookupAll(FilterBuilder.class)) {
            if (!fb.getClass().getName().equals(builderClassName)) continue;
            builder = fb;
        }
        if (builder != null) {
            Filter filter = builder.getFilter();
            FilterController fc = (FilterController)Lookup.getDefault().lookup(FilterController.class);
            Query query = fc.createQuery(filter);
            NodeList paramList = queryE.getElementsByTagName("parameter");
            for (int i = 0; i < paramList.getLength(); ++i) {
                Node n = paramList.item(i);
                if (n.getNodeType() != 1) continue;
                Element paramE = (Element)n;
                int index = Integer.parseInt(paramE.getAttribute("index"));
                FilterProperty property = query.getFilter().getProperties()[index];
                try {
                    PropertyEditor editor = property.getPropertyEditor();
                    if (editor == null) {
                        editor = PropertyEditorManager.findEditor(property.getValueType());
                    }
                    if (editor == null) continue;
                    String textValue = paramE.getTextContent();
                    editor.setAsText(textValue);
                    property.setValue(editor.getValue());
                    this.updateParameters(query);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return query;
        }
        return null;
    }
}

