/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters;

import java.util.ArrayList;
import org.gephi.filters.AbstractQueryImpl;
import org.gephi.filters.FilterQueryImpl;
import org.gephi.filters.OperatorQueryImpl;
import org.gephi.filters.spi.ComplexFilter;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.filters.spi.Operator;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;

public class FilterProcessor {
    public Graph process(AbstractQueryImpl query, GraphModel graphModel) {
        ArrayList<GraphView> views = new ArrayList<GraphView>();
        query = this.simplifyQuery(query);
        AbstractQueryImpl[] tree = this.getTree(query, true);
        for (int i = 0; i < tree.length; ++i) {
            Operator op;
            OperatorQueryImpl operatorQuery;
            AbstractQueryImpl q = tree[tree.length - i - 1];
            Graph[] input = new Graph[]{};
            if (q.getChildrenCount() > 0) {
                input = new Graph[q.getChildrenCount()];
                for (int j = 0; j < input.length; ++j) {
                    input[j] = q.getChildAt(j).getResult();
                }
            } else {
                GraphView newView = graphModel.newView();
                views.add(newView);
                input = new Graph[]{graphModel.getGraph(newView)};
            }
            if (q instanceof OperatorQueryImpl && !((OperatorQueryImpl)q).isSimple()) {
                operatorQuery = (OperatorQueryImpl)q;
                op = (Operator)operatorQuery.getFilter();
                q.setResult(op.filter(input));
                continue;
            }
            if (q instanceof OperatorQueryImpl && ((OperatorQueryImpl)q).isSimple()) {
                operatorQuery = (OperatorQueryImpl)q;
                op = (Operator)operatorQuery.getFilter();
                Filter[] filters = new Filter[operatorQuery.getChildrenCount()];
                for (int k = 0; k < filters.length; ++k) {
                    filters[k] = operatorQuery.getChildAt(k).getFilter();
                }
                GraphView newView = graphModel.newView();
                views.add(newView);
                q.setResult(op.filter(graphModel.getGraph(newView), filters));
                continue;
            }
            FilterQueryImpl filterQuery = (FilterQueryImpl)q;
            Filter filter = filterQuery.getFilter();
            if (filter instanceof NodeFilter && filter instanceof EdgeFilter) {
                this.processNodeFilter((NodeFilter)filter, input[0]);
                this.processEdgeFilter((EdgeFilter)filter, input[0]);
                q.setResult(input[0]);
                continue;
            }
            if (filter instanceof NodeFilter) {
                this.processNodeFilter((NodeFilter)filter, input[0]);
                q.setResult(input[0]);
                continue;
            }
            if (filter instanceof EdgeFilter) {
                this.processEdgeFilter((EdgeFilter)filter, input[0]);
                q.setResult(input[0]);
                continue;
            }
            if (filter instanceof ComplexFilter) {
                ComplexFilter cf = (ComplexFilter)filter;
                q.setResult(cf.filter(input[0]));
                continue;
            }
            q.setResult(input[0]);
        }
        Graph finalResult = tree[0].result;
        GraphView finalView = finalResult.getView();
        for (GraphView v : views) {
            if (v == finalView) continue;
            graphModel.destroyView(v);
        }
        return finalResult;
    }

    private void processNodeFilter(NodeFilter nodeFilter, Graph graph) {
        if (nodeFilter.init(graph)) {
            ArrayList<Node> nodesToRemove = new ArrayList<Node>();
            for (Node n : graph.getNodes()) {
                if (nodeFilter.evaluate(graph, n)) continue;
                nodesToRemove.add(n);
            }
            for (Node n : nodesToRemove) {
                graph.removeNode(n);
            }
            nodeFilter.finish();
        }
    }

    private void processEdgeFilter(EdgeFilter edgeFilter, Graph graph) {
        HierarchicalGraph hgraph = (HierarchicalGraph)graph;
        if (edgeFilter.init(hgraph)) {
            ArrayList<Edge> edgesToRemove = new ArrayList<Edge>();
            for (Edge e : hgraph.getEdges()) {
                if (edgeFilter.evaluate(hgraph, e)) continue;
                edgesToRemove.add(e);
            }
            for (Edge e : edgesToRemove) {
                hgraph.removeEdge(e);
            }
            edgesToRemove.clear();
            for (Edge e : hgraph.getMetaEdges()) {
                if (edgeFilter.evaluate(hgraph, e)) continue;
                edgesToRemove.add(e);
            }
            for (Edge e : edgesToRemove) {
                hgraph.removeMetaEdge(e);
            }
            edgeFilter.finish();
        }
    }

    private AbstractQueryImpl simplifyQuery(AbstractQueryImpl query) {
        AbstractQueryImpl copy = query.copy();
        for (AbstractQueryImpl q : this.getTree(copy, false)) {
            if (!(q instanceof OperatorQueryImpl) || q.getChildrenCount() <= 0) continue;
            boolean canSimplify = true;
            for (AbstractQueryImpl child : q.children) {
                if (child.getChildrenCount() <= 0 && (child.getFilter() instanceof NodeFilter || child.getFilter() instanceof EdgeFilter)) continue;
                canSimplify = false;
            }
            if (!canSimplify) continue;
            ((OperatorQueryImpl)q).setSimple(true);
        }
        return copy;
    }

    private AbstractQueryImpl[] getTree(AbstractQueryImpl query, boolean ignoreSimple) {
        ArrayList<AbstractQueryImpl> tree = new ArrayList<AbstractQueryImpl>();
        int pointer = 0;
        tree.add(query);
        while (pointer < tree.size()) {
            AbstractQueryImpl q = (AbstractQueryImpl)tree.get(pointer++);
            if (q.children.size() <= 0 || q instanceof OperatorQueryImpl && ((OperatorQueryImpl)q).isSimple()) continue;
            tree.addAll(q.children);
        }
        return tree.toArray(new AbstractQueryImpl[0]);
    }
}

