/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters;

import org.gephi.filters.AbstractQueryImpl;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterProperty;

public class FilterQueryImpl
extends AbstractQueryImpl {
    private Parameters[] parameters;
    private Filter filter;
    private String name;

    public FilterQueryImpl(Filter filter) {
        this.filter = filter;
        this.name = filter.getName();
        this.updateParameters();
    }

    public final void updateParameters() {
        FilterProperty[] properties = this.filter.getProperties();
        this.parameters = new Parameters[properties == null ? 0 : properties.length];
        if (properties != null) {
            for (int i = 0; i < properties.length; ++i) {
                this.parameters[i] = new Parameters(i, properties[i].getValue());
            }
        }
    }

    public int getChildrenSlotsCount() {
        return 1;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPropertiesCount() {
        return this.parameters.length;
    }

    public String getPropertyName(int index) {
        return this.parameters[index].getKey();
    }

    public Object getPropertyValue(int index) {
        return this.parameters[index].getValue();
    }

    public Filter getFilter() {
        return this.filter;
    }

    private class Parameters {
        private int index;
        private Object value;

        public Parameters(int index, Object value) {
            this.index = index;
            this.value = value;
        }

        public String getKey() {
            return FilterQueryImpl.this.filter.getProperties()[this.index].getName();
        }

        public Object getValue() {
            return this.value;
        }
    }
}

