/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.api;

public final class Range {
    private final Class rangeType;
    private Double lowerDouble;
    private Double upperDouble;
    private Float lowerFloat;
    private Float upperFloat;
    private Integer lowerInteger;
    private Integer upperInteger;
    private Long lowerLong;
    private Long upperLong;

    public Range(Double lowerBound, Double upperBound) {
        this.lowerDouble = lowerBound;
        this.upperDouble = upperBound;
        this.rangeType = Double.class;
    }

    public Range(Float lowerBound, Float upperBound) {
        this.lowerFloat = lowerBound;
        this.upperFloat = upperBound;
        this.rangeType = Float.class;
    }

    public Range(Integer lowerBound, Integer upperBound) {
        this.lowerInteger = lowerBound;
        this.upperInteger = upperBound;
        this.rangeType = Integer.class;
    }

    public Range(Long lowerBound, Long upperBound) {
        this.lowerLong = lowerBound;
        this.upperLong = upperBound;
        this.rangeType = Long.class;
    }

    public Range(Object lowerBound, Object upperBound) {
        if (lowerBound instanceof Double) {
            this.lowerDouble = (Double)lowerBound;
            this.upperDouble = (Double)upperBound;
            this.rangeType = Double.class;
        } else if (lowerBound instanceof Float) {
            this.lowerFloat = (Float)lowerBound;
            this.upperFloat = (Float)upperBound;
            this.rangeType = Float.class;
        } else if (lowerBound instanceof Integer) {
            this.lowerInteger = (Integer)lowerBound;
            this.upperInteger = (Integer)upperBound;
            this.rangeType = Integer.class;
        } else if (lowerBound instanceof Long) {
            this.lowerLong = (Long)lowerBound;
            this.upperLong = (Long)upperBound;
            this.rangeType = Long.class;
        } else {
            throw new IllegalArgumentException("must be Double, Float, Integer or Long");
        }
    }

    public boolean isInRange(Double value) {
        if (this.rangeType != Double.class) {
            throw new IllegalArgumentException("value must be " + this.rangeType.getName());
        }
        return this.lowerDouble.compareTo(value) <= 0 && this.upperDouble.compareTo(value) >= 0;
    }

    public boolean isInRange(Float value) {
        if (this.rangeType != Float.class) {
            throw new IllegalArgumentException("value must be " + this.rangeType.getName());
        }
        return this.lowerFloat.compareTo(value) <= 0 && this.upperFloat.compareTo(value) >= 0;
    }

    public boolean isInRange(Integer value) {
        if (this.rangeType != Integer.class) {
            throw new IllegalArgumentException("value must be " + this.rangeType.getName());
        }
        return this.lowerInteger.compareTo(value) <= 0 && this.upperInteger.compareTo(value) >= 0;
    }

    public boolean isInRange(Long value) {
        if (this.rangeType != Long.class) {
            throw new IllegalArgumentException("value must be " + this.rangeType.getName());
        }
        return this.lowerLong.compareTo(value) <= 0 && this.upperLong.compareTo(value) >= 0;
    }

    public boolean isInRange(Object value) {
        if (this.rangeType == Double.class) {
            return this.isInRange((Double)value);
        }
        if (this.rangeType == Float.class) {
            return this.isInRange((Float)value);
        }
        if (this.rangeType == Integer.class) {
            return this.isInRange((Integer)value);
        }
        if (this.rangeType == Long.class) {
            return this.isInRange((Long)value);
        }
        return false;
    }

    public void trimBounds(Object min, Object max) {
        if (this.rangeType == Double.class) {
            Double minD = (Double)min;
            Double maxD = (Double)max;
            if (minD > this.lowerDouble || maxD < this.lowerDouble || this.lowerDouble.equals(this.upperDouble)) {
                this.lowerDouble = minD;
            }
            if (minD > this.upperDouble || maxD < this.upperDouble || this.lowerDouble.equals(this.upperDouble)) {
                this.upperDouble = maxD;
            }
        } else if (this.rangeType == Float.class) {
            Float minF = (Float)min;
            Float maxF = (Float)max;
            if (minF.floatValue() > this.lowerFloat.floatValue() || maxF.floatValue() < this.lowerFloat.floatValue() || this.lowerFloat.equals(this.upperFloat)) {
                this.lowerFloat = minF;
            }
            if (minF.floatValue() > this.upperFloat.floatValue() || maxF.floatValue() < this.upperFloat.floatValue() || this.lowerFloat.equals(this.upperFloat)) {
                this.upperFloat = maxF;
            }
        } else if (this.rangeType == Integer.class) {
            Integer minI = (Integer)min;
            Integer maxI = (Integer)max;
            if (minI > this.lowerInteger || maxI < this.lowerInteger || this.lowerInteger.equals(this.upperInteger)) {
                this.lowerInteger = minI;
            }
            if (minI > this.upperInteger || maxI < this.upperInteger || this.lowerInteger.equals(this.upperInteger)) {
                this.upperInteger = maxI;
            }
        } else if (this.rangeType == Long.class) {
            Long minL = (Long)min;
            Long maxL = (Long)max;
            if (minL > this.lowerLong || maxL < this.lowerLong || this.lowerLong.equals(this.upperLong)) {
                this.lowerLong = minL;
            }
            if (minL > this.upperLong || maxL < this.upperLong || this.lowerLong.equals(this.upperLong)) {
                this.upperLong = maxL;
            }
        }
    }

    public Double getLowerDouble() {
        return this.lowerDouble;
    }

    public Float getLowerFloat() {
        return this.lowerFloat;
    }

    public Integer getLowerInteger() {
        return this.lowerInteger;
    }

    public Long getLowerLong() {
        return this.lowerLong;
    }

    public Double getUpperDouble() {
        return this.upperDouble;
    }

    public Float getUpperFloat() {
        return this.upperFloat;
    }

    public Integer getUpperInteger() {
        return this.upperInteger;
    }

    public Long getUpperLong() {
        return this.upperLong;
    }

    public Object getLowerBound() {
        if (this.rangeType == Double.class) {
            return this.lowerDouble;
        }
        if (this.rangeType == Float.class) {
            return this.lowerFloat;
        }
        if (this.rangeType == Integer.class) {
            return this.lowerInteger;
        }
        if (this.rangeType == Long.class) {
            return this.lowerLong;
        }
        return null;
    }

    public Object getUpperBound() {
        if (this.rangeType == Double.class) {
            return this.upperDouble;
        }
        if (this.rangeType == Float.class) {
            return this.upperFloat;
        }
        if (this.rangeType == Integer.class) {
            return this.upperInteger;
        }
        if (this.rangeType == Long.class) {
            return this.upperLong;
        }
        return null;
    }

    public Class getRangeType() {
        return this.rangeType;
    }

    public String toString() {
        if (this.rangeType == Double.class) {
            return this.lowerDouble.toString() + " - " + this.upperDouble.toString();
        }
        if (this.rangeType == Float.class) {
            return this.lowerFloat.toString() + " - " + this.upperFloat.toString();
        }
        if (this.rangeType == Integer.class) {
            return this.lowerInteger.toString() + " - " + this.upperInteger.toString();
        }
        if (this.rangeType == Long.class) {
            return this.lowerLong.toString() + " - " + this.upperLong.toString();
        }
        return "null";
    }
}

