/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin;

import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.dynamic.api.DynamicController;
import org.gephi.dynamic.api.DynamicModel;
import org.gephi.filters.api.FilterController;
import org.gephi.filters.api.FilterModel;
import org.gephi.filters.api.Query;
import org.gephi.filters.plugin.dynamic.DynamicRangeBuilder;
import org.gephi.filters.spi.Filter;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;

public class DynamicAttributesHelper {
    private final FilterModel filterModel;
    private final DynamicModel dynamicModel;
    private final boolean dynamic;

    public DynamicAttributesHelper(Filter filter, Graph graph) {
        if (graph != null) {
            Workspace workspace = graph.getGraphModel().getWorkspace();
            FilterController filterController = (FilterController)Lookup.getDefault().lookup(FilterController.class);
            this.filterModel = filterController.getModel(workspace);
            DynamicController dynamicController = (DynamicController)Lookup.getDefault().lookup(DynamicController.class);
            this.dynamicModel = dynamicController.getModel(workspace);
            this.dynamic = this.isDynamic(filter);
        } else {
            this.filterModel = null;
            this.dynamicModel = null;
            this.dynamic = false;
        }
    }

    private boolean isDynamic(Filter filter) {
        Query filterQuery = null;
        for (Query q : this.filterModel.getCurrentQuery().getQueries(filter.getClass())) {
            if (q.getFilter() != filter) continue;
            filterQuery = q;
            break;
        }
        if (filterQuery != null) {
            for (Query query : filterQuery.getDescendantsAndSelf()) {
                if (!query.getFilter().getClass().equals(DynamicRangeBuilder.DynamicRangeFilter.class)) continue;
                return true;
            }
        }
        return false;
    }

    public Object getDynamicValue(Object attributeValue) {
        if (attributeValue != null && attributeValue instanceof DynamicType) {
            Estimator estimator;
            DynamicType dynamicValue = (DynamicType)attributeValue;
            Estimator estimator2 = estimator = this.dynamicModel == null ? Estimator.FIRST : this.dynamicModel.getEstimator();
            if (Number.class.isAssignableFrom(dynamicValue.getUnderlyingType())) {
                estimator = this.dynamicModel == null ? Estimator.AVERAGE : this.dynamicModel.getNumberEstimator();
            }
            TimeInterval timeInterval = new TimeInterval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            if (this.dynamic) {
                timeInterval = this.dynamicModel.getVisibleInterval();
            }
            return dynamicValue.getValue(timeInterval.getLow(), timeInterval.getHigh(), estimator);
        }
        return attributeValue;
    }

    public float getEdgeWeight(Edge edge) {
        if (this.dynamic) {
            TimeInterval timeInterval = this.dynamicModel.getVisibleInterval();
            return edge.getWeight(timeInterval.getLow(), timeInterval.getHigh());
        }
        return edge.getWeight();
    }
}

