/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.attribute;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.api.AttributeUtils;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.plugin.DynamicAttributesHelper;
import org.gephi.filters.plugin.attribute.ComparableArrayConverter;
import org.gephi.filters.plugin.attribute.EqualBooleanUI;
import org.gephi.filters.plugin.attribute.EqualNumberUI;
import org.gephi.filters.plugin.attribute.EqualStringUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AttributeEqualBuilder
implements CategoryBuilder {
    private static final Category EQUAL = new Category(NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeEqualBuilder.name"), null, FilterLibrary.ATTRIBUTES);

    public Category getCategory() {
        return EQUAL;
    }

    public FilterBuilder[] getBuilders() {
        FilterBuilder b;
        ArrayList<EqualStringFilterBuilder> builders = new ArrayList<EqualStringFilterBuilder>();
        AttributeModel am = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel();
        for (AttributeColumn c : am.getNodeTable().getColumns()) {
            if (AttributeUtils.getDefault().isStringColumn(c) || c.getType().equals((Object)AttributeType.DYNAMIC_STRING)) {
                b = new EqualStringFilterBuilder(c);
                builders.add((EqualStringFilterBuilder)b);
                continue;
            }
            if (AttributeUtils.getDefault().isNumberColumn(c) || AttributeUtils.getDefault().isDynamicNumberColumn(c)) {
                b = new EqualNumberFilterBuilder(c);
                builders.add((EqualStringFilterBuilder)b);
                continue;
            }
            if (!c.getType().equals((Object)AttributeType.BOOLEAN) && !c.getType().equals((Object)AttributeType.DYNAMIC_BOOLEAN)) continue;
            b = new EqualBooleanFilterBuilder(c);
            builders.add((EqualStringFilterBuilder)b);
        }
        for (AttributeColumn c : am.getEdgeTable().getColumns()) {
            if (AttributeUtils.getDefault().isStringColumn(c) || c.getType().equals((Object)AttributeType.DYNAMIC_STRING)) {
                b = new EqualStringFilterBuilder(c);
                builders.add((EqualStringFilterBuilder)b);
                continue;
            }
            if (AttributeUtils.getDefault().isNumberColumn(c) || AttributeUtils.getDefault().isDynamicNumberColumn(c)) {
                b = new EqualNumberFilterBuilder(c);
                builders.add((EqualStringFilterBuilder)b);
                continue;
            }
            if (!c.getType().equals((Object)AttributeType.BOOLEAN) && !c.getType().equals((Object)AttributeType.DYNAMIC_BOOLEAN)) continue;
            b = new EqualBooleanFilterBuilder(c);
            builders.add((EqualStringFilterBuilder)b);
        }
        return builders.toArray(new FilterBuilder[0]);
    }

    public static class EqualBooleanFilter
    implements Filter {
        private FilterProperty[] filterProperties;
        private boolean match = false;
        private AttributeColumn column;
        private DynamicAttributesHelper dynamicHelper = new DynamicAttributesHelper(this, null);

        public String getName() {
            return NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeEqualBuilder.name");
        }

        public FilterProperty[] getProperties() {
            if (this.filterProperties == null) {
                this.filterProperties = new FilterProperty[0];
                try {
                    this.filterProperties = new FilterProperty[]{FilterProperty.createProperty(this, AttributeColumn.class, "column"), FilterProperty.createProperty(this, Boolean.class, "match")};
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return this.filterProperties;
        }

        public boolean init(Graph graph) {
            HierarchicalGraph hg = (HierarchicalGraph)graph;
            this.dynamicHelper = new DynamicAttributesHelper(this, hg);
            return true;
        }

        public boolean evaluate(Graph graph, Node node) {
            Object val = node.getNodeData().getAttributes().getValue(this.column.getIndex());
            if ((val = this.dynamicHelper.getDynamicValue(val)) != null) {
                return val.equals(this.match);
            }
            return false;
        }

        public boolean evaluate(Graph graph, Edge edge) {
            Object val = edge.getEdgeData().getAttributes().getValue(this.column.getIndex());
            if ((val = this.dynamicHelper.getDynamicValue(val)) != null) {
                return val.equals(this.match);
            }
            return false;
        }

        public void finish() {
        }

        public boolean isMatch() {
            return this.match;
        }

        public void setMatch(boolean match) {
            this.match = match;
        }

        public AttributeColumn getColumn() {
            return this.column;
        }

        public void setColumn(AttributeColumn column) {
            this.column = column;
        }
    }

    public static class EdgeEqualBooleanFilter
    extends EqualBooleanFilter
    implements EdgeFilter {
    }

    public static class NodeEqualBooleanFilter
    extends EqualBooleanFilter
    implements NodeFilter {
    }

    private static class EqualBooleanFilterBuilder
    implements FilterBuilder {
        private final AttributeColumn column;

        public EqualBooleanFilterBuilder(AttributeColumn column) {
            this.column = column;
        }

        public Category getCategory() {
            return EQUAL;
        }

        public String getName() {
            return "<font color='#000000'>" + this.column.getTitle() + "</font> " + "<font color='#999999'><i>" + this.column.getType().toString() + " " + (AttributeUtils.getDefault().isNodeColumn(this.column) ? "(Node)" : "(Edge)") + "</i></font>";
        }

        public Icon getIcon() {
            return null;
        }

        public String getDescription() {
            return NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeEqualBuilder.description");
        }

        public EqualBooleanFilter getFilter() {
            if (AttributeUtils.getDefault().isNodeColumn(this.column)) {
                NodeEqualBooleanFilter f = new NodeEqualBooleanFilter();
                f.setColumn(this.column);
                return f;
            }
            EdgeEqualBooleanFilter f = new EdgeEqualBooleanFilter();
            f.setColumn(this.column);
            return f;
        }

        public JPanel getPanel(Filter filter) {
            EqualBooleanUI ui = (EqualBooleanUI)Lookup.getDefault().lookup(EqualBooleanUI.class);
            if (ui != null) {
                return ui.getPanel((EqualBooleanFilter)filter);
            }
            return null;
        }

        public void destroy(Filter filter) {
        }
    }

    public static class EqualNumberFilter
    implements Filter {
        private FilterProperty[] filterProperties;
        private Number match;
        private AttributeColumn column;
        private Object min;
        private Object max;
        private List<Object> values;
        private DynamicAttributesHelper dynamicHelper = new DynamicAttributesHelper(this, null);

        public EqualNumberFilter(AttributeColumn column) {
            this.column = column;
            this.dynamicHelper = new DynamicAttributesHelper(this, null);
        }

        public String getName() {
            return NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeEqualBuilder.name");
        }

        public boolean init(Graph graph) {
            HierarchicalGraph hg = (HierarchicalGraph)graph;
            this.values = new ArrayList<Object>();
            this.dynamicHelper = new DynamicAttributesHelper(this, hg);
            return true;
        }

        public boolean evaluate(Graph graph, Node node) {
            Object val = node.getNodeData().getAttributes().getValue(this.column.getIndex());
            if ((val = this.dynamicHelper.getDynamicValue(val)) != null) {
                this.values.add(val);
                return val.equals(this.match);
            }
            return false;
        }

        public boolean evaluate(Graph graph, Edge edge) {
            Object val = edge.getEdgeData().getAttributes().getValue(this.column.getIndex());
            if ((val = this.dynamicHelper.getDynamicValue(val)) != null) {
                this.values.add(val);
                return val.equals(this.match);
            }
            return false;
        }

        public void finish() {
            Comparable[] comparableArray = ComparableArrayConverter.convert(this.values);
            this.min = AttributeUtils.getDefault().getMin(this.column, comparableArray);
            this.max = AttributeUtils.getDefault().getMax(this.column, comparableArray);
            this.values = null;
        }

        private void refreshValues() {
            GraphModel gm = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
            HierarchicalGraph hgraph = gm.getHierarchicalGraphVisible();
            ArrayList<Object> vals = new ArrayList<Object>();
            if (AttributeUtils.getDefault().isNodeColumn(this.column)) {
                for (Node n : hgraph.getNodes()) {
                    Object val = n.getNodeData().getAttributes().getValue(this.column.getIndex());
                    if (val == null) continue;
                    vals.add(val);
                }
            } else {
                for (Edge e : hgraph.getEdgesAndMetaEdges()) {
                    Object val = e.getEdgeData().getAttributes().getValue(this.column.getIndex());
                    if (val == null) continue;
                    vals.add(val);
                }
            }
            if (vals.isEmpty()) {
                vals.add(0);
            }
            Comparable[] comparableArray = ComparableArrayConverter.convert(vals);
            this.min = AttributeUtils.getDefault().getMin(this.column, comparableArray);
            this.max = AttributeUtils.getDefault().getMax(this.column, comparableArray);
        }

        public FilterProperty[] getProperties() {
            if (this.filterProperties == null) {
                this.filterProperties = new FilterProperty[0];
                try {
                    this.filterProperties = new FilterProperty[]{FilterProperty.createProperty(this, AttributeColumn.class, "column"), FilterProperty.createProperty(this, Number.class, "match")};
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return this.filterProperties;
        }

        public Number getMatch() {
            return this.match;
        }

        public void setMatch(Number match) {
            this.match = match;
        }

        public Object getMinimun() {
            if (this.min == null) {
                this.refreshValues();
            }
            return this.min;
        }

        public Object getMaximum() {
            if (this.max == null) {
                this.refreshValues();
            }
            return this.max;
        }

        public AttributeColumn getColumn() {
            return this.column;
        }

        public void setColumn(AttributeColumn column) {
            this.column = column;
        }
    }

    public static class EdgeEqualNumberFilter
    extends EqualNumberFilter
    implements EdgeFilter {
        public EdgeEqualNumberFilter(AttributeColumn column) {
            super(column);
        }
    }

    public static class NodeEqualNumberFilter
    extends EqualNumberFilter
    implements NodeFilter {
        public NodeEqualNumberFilter(AttributeColumn column) {
            super(column);
        }
    }

    private static class EqualNumberFilterBuilder
    implements FilterBuilder {
        private final AttributeColumn column;

        public EqualNumberFilterBuilder(AttributeColumn column) {
            this.column = column;
        }

        public Category getCategory() {
            return EQUAL;
        }

        public String getName() {
            return "<font color='#000000'>" + this.column.getTitle() + "</font> " + "<font color='#999999'><i>" + this.column.getType().toString() + " " + (AttributeUtils.getDefault().isNodeColumn(this.column) ? "(Node)" : "(Edge)") + "</i></font>";
        }

        public Icon getIcon() {
            return null;
        }

        public String getDescription() {
            return NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeEqualBuilder.description");
        }

        public EqualNumberFilter getFilter() {
            if (AttributeUtils.getDefault().isNodeColumn(this.column)) {
                return new NodeEqualNumberFilter(this.column);
            }
            return new EdgeEqualNumberFilter(this.column);
        }

        public JPanel getPanel(Filter filter) {
            EqualNumberUI ui = (EqualNumberUI)Lookup.getDefault().lookup(EqualNumberUI.class);
            if (ui != null) {
                return ui.getPanel((EqualNumberFilter)filter);
            }
            return null;
        }

        public void destroy(Filter filter) {
        }
    }

    public static class EqualStringFilter
    implements Filter {
        private FilterProperty[] filterProperties;
        private String pattern;
        private boolean useRegex;
        private AttributeColumn column;
        private Pattern regex;
        private DynamicAttributesHelper dynamicHelper = new DynamicAttributesHelper(this, null);

        public String getName() {
            return NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeEqualBuilder.name");
        }

        public boolean init(Graph graph) {
            HierarchicalGraph hg = (HierarchicalGraph)graph;
            this.dynamicHelper = new DynamicAttributesHelper(this, hg);
            return true;
        }

        public boolean evaluate(Graph graph, Node node) {
            if (this.pattern == null) {
                return true;
            }
            Object val = node.getNodeData().getAttributes().getValue(this.column.getIndex());
            if ((val = this.dynamicHelper.getDynamicValue(val)) != null && this.useRegex) {
                return this.regex.matcher((String)val).matches();
            }
            if (val != null) {
                return this.pattern.equals((String)val);
            }
            return false;
        }

        public boolean evaluate(Graph graph, Edge edge) {
            Object val = edge.getEdgeData().getAttributes().getValue(this.column.getIndex());
            if ((val = this.dynamicHelper.getDynamicValue(val)) != null && this.useRegex) {
                return this.regex.matcher((String)val).matches();
            }
            if (val != null) {
                return this.pattern.contains((String)val);
            }
            return false;
        }

        public void finish() {
        }

        public FilterProperty[] getProperties() {
            if (this.filterProperties == null) {
                this.filterProperties = new FilterProperty[0];
                try {
                    this.filterProperties = new FilterProperty[]{FilterProperty.createProperty(this, AttributeColumn.class, "column"), FilterProperty.createProperty(this, String.class, "pattern"), FilterProperty.createProperty(this, Boolean.class, "useRegex")};
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return this.filterProperties;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
            this.regex = Pattern.compile(pattern);
        }

        public boolean isUseRegex() {
            return this.useRegex;
        }

        public void setUseRegex(boolean useRegex) {
            this.useRegex = useRegex;
        }

        public AttributeColumn getColumn() {
            return this.column;
        }

        public void setColumn(AttributeColumn column) {
            this.column = column;
        }
    }

    public static class EdgeEqualStringFilter
    extends EqualStringFilter
    implements EdgeFilter {
    }

    public static class NodeEqualStringFilter
    extends EqualStringFilter
    implements NodeFilter {
    }

    private static class EqualStringFilterBuilder
    implements FilterBuilder {
        private final AttributeColumn column;

        public EqualStringFilterBuilder(AttributeColumn column) {
            this.column = column;
        }

        public Category getCategory() {
            return EQUAL;
        }

        public String getName() {
            return "<font color='#000000'>" + this.column.getTitle() + "</font> " + "<font color='#999999'><i>" + this.column.getType().toString() + " " + (AttributeUtils.getDefault().isNodeColumn(this.column) ? "(Node)" : "(Edge)") + "</i></font>";
        }

        public Icon getIcon() {
            return null;
        }

        public String getDescription() {
            return NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeEqualBuilder.description");
        }

        public EqualStringFilter getFilter() {
            if (AttributeUtils.getDefault().isNodeColumn(this.column)) {
                NodeEqualStringFilter f = new NodeEqualStringFilter();
                f.setColumn(this.column);
                return f;
            }
            EdgeEqualStringFilter f = new EdgeEqualStringFilter();
            f.setColumn(this.column);
            return f;
        }

        public JPanel getPanel(Filter filter) {
            EqualStringUI ui = (EqualStringUI)Lookup.getDefault().lookup(EqualStringUI.class);
            if (ui != null) {
                return ui.getPanel((EqualStringFilter)filter);
            }
            return null;
        }

        public void destroy(Filter filter) {
        }
    }
}

