/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.attribute;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeUtils;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.plugin.attribute.AttributeEqualBuilder;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AttributeNonNullBuilder
implements CategoryBuilder {
    private static final Category NONNULL = new Category(NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeNonNullBuilder.name"), null, FilterLibrary.ATTRIBUTES);

    public Category getCategory() {
        return NONNULL;
    }

    public FilterBuilder[] getBuilders() {
        AttributeNonNullFilterBuilder b;
        ArrayList<AttributeNonNullFilterBuilder> builders = new ArrayList<AttributeNonNullFilterBuilder>();
        AttributeModel am = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel();
        for (AttributeColumn c : am.getNodeTable().getColumns()) {
            b = new AttributeNonNullFilterBuilder(c);
            builders.add(b);
        }
        for (AttributeColumn c : am.getEdgeTable().getColumns()) {
            b = new AttributeNonNullFilterBuilder(c);
            builders.add(b);
        }
        return builders.toArray(new FilterBuilder[0]);
    }

    public static class AttributeNonNullFilter
    implements Filter {
        private FilterProperty[] filterProperties;
        private AttributeColumn column;

        public String getName() {
            return NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeNonNullBuilder.name");
        }

        public boolean init(Graph graph) {
            return true;
        }

        public boolean evaluate(Graph graph, Edge edge) {
            return edge.getEdgeData().getAttributes().getValue(this.column.getIndex()) != null;
        }

        public boolean evaluate(Graph graph, Node node) {
            return node.getNodeData().getAttributes().getValue(this.column.getIndex()) != null;
        }

        public void finish() {
        }

        public FilterProperty[] getProperties() {
            if (this.filterProperties == null) {
                this.filterProperties = new FilterProperty[0];
                try {
                    this.filterProperties = new FilterProperty[]{FilterProperty.createProperty(this, AttributeColumn.class, "column")};
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return this.filterProperties;
        }

        public AttributeColumn getColumn() {
            return this.column;
        }

        public void setColumn(AttributeColumn column) {
            this.column = column;
        }
    }

    public static class EdgeAttributeNonNullFilter
    extends AttributeNonNullFilter
    implements EdgeFilter {
    }

    public static class NodeAttributeNonNullFilter
    extends AttributeNonNullFilter
    implements NodeFilter {
    }

    private static class AttributeNonNullFilterBuilder
    implements FilterBuilder {
        private final AttributeColumn column;

        public AttributeNonNullFilterBuilder(AttributeColumn column) {
            this.column = column;
        }

        public Category getCategory() {
            return NONNULL;
        }

        public String getName() {
            return "<font color='#000000'>" + this.column.getTitle() + "</font> " + "<font color='#999999'><i>" + this.column.getType().toString() + " " + (AttributeUtils.getDefault().isNodeColumn(this.column) ? "(Node)" : "(Edge)") + "</i></font>";
        }

        public Icon getIcon() {
            return null;
        }

        public String getDescription() {
            return NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeNonNullBuilder.description");
        }

        public AttributeNonNullFilter getFilter() {
            if (AttributeUtils.getDefault().isNodeColumn(this.column)) {
                NodeAttributeNonNullFilter f = new NodeAttributeNonNullFilter();
                f.setColumn(this.column);
                return f;
            }
            EdgeAttributeNonNullFilter f = new EdgeAttributeNonNullFilter();
            f.setColumn(this.column);
            return f;
        }

        public JPanel getPanel(Filter filter) {
            return null;
        }

        public void destroy(Filter filter) {
        }
    }
}

