/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.attribute;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeUtils;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.api.Range;
import org.gephi.filters.plugin.DynamicAttributesHelper;
import org.gephi.filters.plugin.RangeFilter;
import org.gephi.filters.plugin.attribute.AttributeEqualBuilder;
import org.gephi.filters.plugin.attribute.ComparableArrayConverter;
import org.gephi.filters.plugin.graph.RangeUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AttributeRangeBuilder
implements CategoryBuilder {
    private static final Category RANGE = new Category(NbBundle.getMessage(AttributeRangeBuilder.class, (String)"AttributeRangeBuilder.name"), null, FilterLibrary.ATTRIBUTES);

    public Category getCategory() {
        return RANGE;
    }

    public FilterBuilder[] getBuilders() {
        AttributeRangeFilterBuilder b;
        ArrayList<AttributeRangeFilterBuilder> builders = new ArrayList<AttributeRangeFilterBuilder>();
        AttributeModel am = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel();
        for (AttributeColumn c : am.getNodeTable().getColumns()) {
            if (!AttributeUtils.getDefault().isNumberColumn(c) && !AttributeUtils.getDefault().isDynamicNumberColumn(c)) continue;
            b = new AttributeRangeFilterBuilder(c);
            builders.add(b);
        }
        for (AttributeColumn c : am.getEdgeTable().getColumns()) {
            if (!AttributeUtils.getDefault().isNumberColumn(c) && !AttributeUtils.getDefault().isDynamicNumberColumn(c)) continue;
            b = new AttributeRangeFilterBuilder(c);
            builders.add(b);
        }
        return builders.toArray(new FilterBuilder[0]);
    }

    public static class AttributeRangeFilter
    implements RangeFilter,
    Filter {
        private FilterProperty[] filterProperties;
        private Range range;
        private AttributeColumn column;
        private Object min = 0;
        private Object max = 0;
        private DynamicAttributesHelper dynamicHelper = new DynamicAttributesHelper(this, null);
        private List<Object> values;

        public AttributeRangeFilter(AttributeColumn column) {
            this.column = column;
        }

        public String getName() {
            return this.column.getTitle() + " " + NbBundle.getMessage(AttributeRangeBuilder.class, (String)"AttributeRangeBuilder.name");
        }

        private void refreshRange() {
            if (this.range == null) {
                this.range = new Range(this.min, this.max);
            } else if (!this.min.equals(this.max)) {
                this.range.trimBounds(this.min, this.max);
            }
        }

        public boolean init(Graph graph) {
            HierarchicalGraph hg = graph.getGraphModel().getHierarchicalGraphVisible();
            this.dynamicHelper = new DynamicAttributesHelper(this, hg);
            if (this.range == null) {
                this.getValues();
                this.refreshRange();
            }
            this.values = new ArrayList<Object>();
            return true;
        }

        public boolean evaluate(Graph graph, Node node) {
            Object val = node.getNodeData().getAttributes().getValue(this.column.getIndex());
            if ((val = this.dynamicHelper.getDynamicValue(val)) != null) {
                this.values.add(val);
                return this.range.isInRange(val);
            }
            return false;
        }

        public boolean evaluate(Graph graph, Edge edge) {
            Object val = edge.getEdgeData().getAttributes().getValue(this.column.getIndex());
            if ((val = this.dynamicHelper.getDynamicValue(val)) != null) {
                this.values.add(val);
                return this.range.isInRange(val);
            }
            return false;
        }

        public void finish() {
            this.refreshRange();
        }

        public Object[] getValues() {
            if (this.values == null) {
                GraphModel gm = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
                HierarchicalGraph hgraph = gm.getHierarchicalGraphVisible();
                ArrayList<Object> vals = new ArrayList<Object>();
                if (AttributeUtils.getDefault().isNodeColumn(this.column)) {
                    for (Node n : hgraph.getNodes()) {
                        Object val = n.getNodeData().getAttributes().getValue(this.column.getIndex());
                        if ((val = this.dynamicHelper.getDynamicValue(val)) == null) continue;
                        vals.add(val);
                    }
                } else {
                    for (Edge e : hgraph.getEdgesAndMetaEdges()) {
                        Object val = e.getEdgeData().getAttributes().getValue(this.column.getIndex());
                        if ((val = this.dynamicHelper.getDynamicValue(val)) == null) continue;
                        vals.add(val);
                    }
                }
                if (vals.isEmpty()) {
                    vals.add(0);
                }
                Object[] comparableArray = ComparableArrayConverter.convert(vals);
                this.min = AttributeUtils.getDefault().getMin(this.column, (Comparable[])comparableArray);
                this.max = AttributeUtils.getDefault().getMax(this.column, (Comparable[])comparableArray);
                this.refreshRange();
                return comparableArray;
            }
            Object[] comparableArray = ComparableArrayConverter.convert(this.values);
            this.min = AttributeUtils.getDefault().getMin(this.column, (Comparable[])comparableArray);
            this.max = AttributeUtils.getDefault().getMax(this.column, (Comparable[])comparableArray);
            return comparableArray;
        }

        public FilterProperty[] getProperties() {
            if (this.filterProperties == null) {
                this.filterProperties = new FilterProperty[0];
                try {
                    this.filterProperties = new FilterProperty[]{FilterProperty.createProperty(this, AttributeColumn.class, "column"), FilterProperty.createProperty(this, Range.class, "range")};
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return this.filterProperties;
        }

        public FilterProperty getRangeProperty() {
            return this.getProperties()[1];
        }

        public Object getMinimum() {
            return this.min;
        }

        public Object getMaximum() {
            return this.max;
        }

        public Range getRange() {
            return this.range;
        }

        public void setRange(Range range) {
            this.range = range;
        }

        public AttributeColumn getColumn() {
            return this.column;
        }

        public void setColumn(AttributeColumn column) {
            this.column = column;
        }
    }

    public static class EdgeAttributeRangeFilter
    extends AttributeRangeFilter
    implements EdgeFilter {
        public EdgeAttributeRangeFilter(AttributeColumn column) {
            super(column);
        }
    }

    public static class NodeAttributeRangeFilter
    extends AttributeRangeFilter
    implements NodeFilter {
        public NodeAttributeRangeFilter(AttributeColumn column) {
            super(column);
        }
    }

    private static class AttributeRangeFilterBuilder
    implements FilterBuilder {
        private final AttributeColumn column;

        public AttributeRangeFilterBuilder(AttributeColumn column) {
            this.column = column;
        }

        public Category getCategory() {
            return RANGE;
        }

        public String getName() {
            return "<font color='#000000'>" + this.column.getTitle() + "</font> " + "<font color='#999999'><i>" + this.column.getType().toString() + " " + (AttributeUtils.getDefault().isNodeColumn(this.column) ? "(Node)" : "(Edge)") + "</i></font>";
        }

        public Icon getIcon() {
            return null;
        }

        public String getDescription() {
            return NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeRangeBuilder.description");
        }

        public AttributeRangeFilter getFilter() {
            if (AttributeUtils.getDefault().isNodeColumn(this.column)) {
                return new NodeAttributeRangeFilter(this.column);
            }
            return new EdgeAttributeRangeFilter(this.column);
        }

        public JPanel getPanel(Filter filter) {
            RangeUI ui = (RangeUI)Lookup.getDefault().lookup(RangeUI.class);
            if (ui != null) {
                return ui.getPanel((AttributeRangeFilter)filter);
            }
            return null;
        }

        public void destroy(Filter filter) {
        }
    }
}

