/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.dynamic;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.dynamic.api.DynamicController;
import org.gephi.dynamic.api.DynamicModel;
import org.gephi.dynamic.api.DynamicModelEvent;
import org.gephi.dynamic.api.DynamicModelListener;
import org.gephi.filters.api.Range;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.timeline.api.TimelineController;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DynamicRangeBuilder
implements CategoryBuilder {
    private static final Category DYNAMIC = new Category(NbBundle.getMessage(DynamicRangeBuilder.class, (String)"DynamicRangeBuilder.category"), null, null);

    public Category getCategory() {
        return DYNAMIC;
    }

    public FilterBuilder[] getBuilders() {
        ArrayList<DynamicRangeFilterBuilder> builders = new ArrayList<DynamicRangeFilterBuilder>();
        AttributeModel am = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel();
        AttributeColumn nodeColumn = am.getNodeTable().getColumn("time_interval");
        AttributeColumn edgeColumn = am.getEdgeTable().getColumn("time_interval");
        if (nodeColumn != null || edgeColumn != null) {
            builders.add(new DynamicRangeFilterBuilder(nodeColumn, edgeColumn));
        }
        return builders.toArray(new FilterBuilder[0]);
    }

    public static class DynamicRangeFilter
    implements NodeFilter,
    EdgeFilter,
    DynamicModelListener {
        private AttributeColumn nodeColumn;
        private AttributeColumn edgeColumn;
        private DynamicController dynamicController;
        private DynamicModel dynamicModel;
        private TimelineController timelineController;
        private TimeInterval visibleInterval;
        private FilterProperty[] filterProperties;
        private Double min;
        private Double max;
        private boolean keepNonDynamic = true;

        public DynamicRangeFilter(TimelineController timelineController, DynamicController dynamicController, AttributeColumn nodeColumn, AttributeColumn edgeColumn) {
            this.nodeColumn = nodeColumn;
            this.edgeColumn = edgeColumn;
            this.dynamicController = dynamicController;
            this.dynamicModel = dynamicController.getModel();
            this.timelineController = timelineController;
            this.min = this.dynamicModel.getMin();
            this.max = this.dynamicModel.getMax();
            if (timelineController != null) {
                timelineController.setMin(this.min);
                timelineController.setMax(this.max);
            }
            this.visibleInterval = this.dynamicModel.getVisibleInterval();
        }

        public boolean init(Graph graph) {
            this.dynamicController.addModelListener(this);
            this.visibleInterval = this.dynamicModel.getVisibleInterval();
            this.min = Double.POSITIVE_INFINITY;
            this.max = Double.NEGATIVE_INFINITY;
            return true;
        }

        public boolean evaluate(Graph graph, Node node) {
            Object obj;
            if (this.nodeColumn != null && (obj = node.getNodeData().getAttributes().getValue(this.nodeColumn.getIndex())) != null) {
                TimeInterval timeInterval = (TimeInterval)obj;
                this.min = Math.min(this.min, Double.isInfinite(timeInterval.getLow()) ? this.min.doubleValue() : timeInterval.getLow());
                this.max = Math.max(this.max, Double.isInfinite(timeInterval.getHigh()) ? this.max.doubleValue() : timeInterval.getHigh());
                return timeInterval.isInRange(this.visibleInterval.getLow(), this.visibleInterval.getHigh());
            }
            return this.keepNonDynamic;
        }

        public boolean evaluate(Graph graph, Edge edge) {
            Object obj;
            if (this.edgeColumn != null && (obj = edge.getEdgeData().getAttributes().getValue(this.edgeColumn.getIndex())) != null) {
                TimeInterval timeInterval = (TimeInterval)obj;
                this.min = Math.min(this.min, Double.isInfinite(timeInterval.getLow()) ? this.min.doubleValue() : timeInterval.getLow());
                this.max = Math.max(this.max, Double.isInfinite(timeInterval.getHigh()) ? this.max.doubleValue() : timeInterval.getHigh());
                return timeInterval.isInRange(this.visibleInterval.getLow(), this.visibleInterval.getHigh());
            }
            return this.keepNonDynamic;
        }

        public void finish() {
            if (Double.isInfinite(this.min) || this.timelineController != null) {
                // empty if block
            }
            if (Double.isInfinite(this.max) || this.timelineController != null) {
                // empty if block
            }
        }

        public String getName() {
            return NbBundle.getMessage(DynamicRangeBuilder.class, (String)"DynamicRangeBuilder.name");
        }

        public FilterProperty[] getProperties() {
            if (this.filterProperties == null) {
                this.filterProperties = new FilterProperty[0];
                try {
                    this.filterProperties = new FilterProperty[]{FilterProperty.createProperty(this, Range.class, "range")};
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return this.filterProperties;
        }

        public void dynamicModelChanged(DynamicModelEvent event) {
            switch (event.getEventType()) {
                case VISIBLE_INTERVAL: {
                    TimeInterval interval = (TimeInterval)event.getData();
                    this.getProperties()[0].setValue(new Range(interval.getLow(), interval.getHigh()));
                }
            }
        }

        public FilterProperty getRangeProperty() {
            return this.getProperties()[0];
        }

        public Double getMinimum() {
            return this.min;
        }

        public Double getMaximum() {
            return this.max;
        }

        public Range getRange() {
            return new Range(this.visibleInterval.getLow(), this.visibleInterval.getHigh());
        }

        public void setRange(Range range) {
            this.dynamicController.setVisibleInterval(range.getLowerDouble(), range.getUpperDouble());
        }

        public void destroy() {
            this.dynamicController.removeModelListener(this);
        }
    }

    private static class DynamicRangeFilterBuilder
    implements FilterBuilder {
        private final AttributeColumn nodeColumn;
        private final AttributeColumn edgeColumn;

        public DynamicRangeFilterBuilder(AttributeColumn nodeColumn, AttributeColumn edgeColumn) {
            this.nodeColumn = nodeColumn;
            this.edgeColumn = edgeColumn;
        }

        public Category getCategory() {
            return DYNAMIC;
        }

        public String getName() {
            return "Time Interval";
        }

        public Icon getIcon() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public DynamicRangeFilter getFilter() {
            TimelineController timelineController = (TimelineController)Lookup.getDefault().lookup(TimelineController.class);
            DynamicController dynamicController = (DynamicController)Lookup.getDefault().lookup(DynamicController.class);
            return new DynamicRangeFilter(timelineController, dynamicController, this.nodeColumn, this.edgeColumn);
        }

        public JPanel getPanel(Filter filter) {
            DynamicRangeFilter dynamicRangeFilter = (DynamicRangeFilter)filter;
            JPanel panel = new JPanel();
            final TopComponent topComponent = WindowManager.getDefault().findTopComponent("TimelineTopComponent");
            final JButton button = new JButton(topComponent.isOpened() ? "Close Timeline" : "Open Timeline");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!topComponent.isOpened()) {
                        topComponent.open();
                        topComponent.requestActive();
                        button.setText("Close Timeline");
                    } else {
                        topComponent.close();
                        button.setText("Open Timeline");
                    }
                }
            });
            panel.add(button);
            return panel;
        }

        public void destroy(Filter filter) {
            ((DynamicRangeFilter)filter).destroy();
        }
    }
}

