/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.edge;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.api.Range;
import org.gephi.filters.plugin.DynamicAttributesHelper;
import org.gephi.filters.plugin.RangeFilter;
import org.gephi.filters.plugin.graph.RangeUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalGraph;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class EdgeWeightBuilder
implements FilterBuilder {
    public Category getCategory() {
        return FilterLibrary.EDGE;
    }

    public String getName() {
        return NbBundle.getMessage(EdgeWeightBuilder.class, (String)"EdgeWeightBuilder.name");
    }

    public Icon getIcon() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(EdgeWeightBuilder.class, (String)"EdgeWeightBuilder.description");
    }

    public Filter getFilter() {
        return new EdgeWeightFilter();
    }

    public JPanel getPanel(Filter filter) {
        RangeUI ui = (RangeUI)Lookup.getDefault().lookup(RangeUI.class);
        if (ui != null) {
            return ui.getPanel((EdgeWeightFilter)filter);
        }
        return null;
    }

    public void destroy(Filter filter) {
    }

    public static class EdgeWeightFilter
    implements RangeFilter,
    EdgeFilter {
        private Float min = Float.valueOf(0.0f);
        private Float max = Float.valueOf(0.0f);
        private Range range;
        private DynamicAttributesHelper dynamicHelper = new DynamicAttributesHelper(this, null);
        private List<Float> values;

        public String getName() {
            return NbBundle.getMessage(EdgeWeightBuilder.class, (String)"EdgeWeightBuilder.name");
        }

        private void refreshRange() {
            if (this.range == null) {
                this.range = new Range(this.min, this.max);
            } else {
                this.range.trimBounds(this.min, this.max);
            }
        }

        public boolean init(Graph graph) {
            HierarchicalGraph hgraph = (HierarchicalGraph)graph;
            this.dynamicHelper = new DynamicAttributesHelper(this, hgraph);
            if (this.range == null) {
                this.getValues();
                this.refreshRange();
            }
            this.values = new ArrayList<Float>(hgraph.getTotalEdgeCount());
            this.min = Float.valueOf(Float.POSITIVE_INFINITY);
            this.max = Float.valueOf(Float.NEGATIVE_INFINITY);
            return true;
        }

        public boolean evaluate(Graph graph, Edge edge) {
            float weight = this.dynamicHelper.getEdgeWeight(edge);
            this.min = Float.valueOf(Math.min(this.min.floatValue(), weight));
            this.max = Float.valueOf(Math.max(this.max.floatValue(), weight));
            this.values.add(new Float(weight));
            return this.range.isInRange(Float.valueOf(weight));
        }

        public void finish() {
            this.refreshRange();
        }

        public Object[] getValues() {
            if (this.values == null) {
                GraphModel gm = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
                HierarchicalGraph hgraph = gm.getHierarchicalGraphVisible();
                Object[] weights = new Float[hgraph.getTotalEdgeCount()];
                int i = 0;
                this.min = Float.valueOf(Float.MAX_VALUE);
                this.max = Float.valueOf(Float.MIN_VALUE);
                for (Edge e : hgraph.getEdgesAndMetaEdges()) {
                    float weight = this.dynamicHelper.getEdgeWeight(e);
                    this.min = Float.valueOf(Math.min(this.min.floatValue(), weight));
                    this.max = Float.valueOf(Math.max(this.max.floatValue(), weight));
                    weights[i++] = Float.valueOf(weight);
                }
                this.refreshRange();
                return weights;
            }
            return this.values.toArray(new Float[0]);
        }

        public FilterProperty[] getProperties() {
            try {
                return new FilterProperty[]{FilterProperty.createProperty(this, Range.class, "range")};
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return new FilterProperty[0];
            }
        }

        public FilterProperty getRangeProperty() {
            return this.getProperties()[0];
        }

        public Object getMinimum() {
            return this.min;
        }

        public Object getMaximum() {
            return this.max;
        }

        public Range getRange() {
            return this.range;
        }

        public void setRange(Range range) {
            this.range = range;
        }
    }
}

