/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.graph;

import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.HierarchicalUndirectedGraph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.UndirectedGraph;
import org.gephi.statistics.plugin.ConnectedComponents;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class GiantComponentBuilder
implements FilterBuilder {
    public Category getCategory() {
        return FilterLibrary.TOPOLOGY;
    }

    public String getName() {
        return NbBundle.getMessage(GiantComponentBuilder.class, (String)"GiantComponentBuilder.name");
    }

    public Icon getIcon() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(GiantComponentBuilder.class, (String)"GiantComponentBuilder.description");
    }

    public Filter getFilter() {
        return new GiantComponentFilter();
    }

    public JPanel getPanel(Filter filter) {
        return null;
    }

    public void destroy(Filter filter) {
    }

    public static class GiantComponentFilter
    implements NodeFilter {
        private AttributeModel attributeModel = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel();
        private int componentId;
        private AttributeColumn column;

        public boolean init(Graph graph) {
            ConnectedComponents cc = new ConnectedComponents();
            HierarchicalUndirectedGraph undirectedGraph = null;
            undirectedGraph = cc instanceof UndirectedGraph ? (HierarchicalUndirectedGraph)graph : graph.getView().getGraphModel().getHierarchicalUndirectedGraph(graph.getView());
            cc.weaklyConnected(undirectedGraph, this.attributeModel);
            this.componentId = cc.getGiantComponent();
            this.column = this.attributeModel.getNodeTable().getColumn("componentnumber");
            return this.column != null && this.componentId != -1;
        }

        public boolean evaluate(Graph graph, Node node) {
            Integer component = (Integer)node.getNodeData().getAttributes().getValue(this.column.getIndex());
            if (component != null) {
                return component.equals(this.componentId);
            }
            return false;
        }

        public void finish() {
        }

        public String getName() {
            return NbBundle.getMessage(GiantComponentBuilder.class, (String)"GiantComponentBuilder.name");
        }

        public FilterProperty[] getProperties() {
            return new FilterProperty[0];
        }
    }
}

