/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.graph;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.api.Range;
import org.gephi.filters.plugin.RangeFilter;
import org.gephi.filters.plugin.graph.RangeUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalDirectedGraph;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class OutDegreeRangeBuilder
implements FilterBuilder {
    public Category getCategory() {
        return FilterLibrary.TOPOLOGY;
    }

    public String getName() {
        return NbBundle.getMessage(OutDegreeRangeBuilder.class, (String)"OutDegreeRangeBuilder.name");
    }

    public Icon getIcon() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(OutDegreeRangeBuilder.class, (String)"OutDegreeRangeBuilder.description");
    }

    public Filter getFilter() {
        return new OutDegreeRangeFilter();
    }

    public JPanel getPanel(Filter filter) {
        RangeUI ui = (RangeUI)Lookup.getDefault().lookup(RangeUI.class);
        if (ui != null) {
            return ui.getPanel((OutDegreeRangeFilter)filter);
        }
        return null;
    }

    public void destroy(Filter filter) {
    }

    public static class OutDegreeRangeFilter
    implements RangeFilter,
    NodeFilter {
        private Integer min = 0;
        private Integer max = 0;
        private Range range;
        private List<Integer> values;

        public String getName() {
            return NbBundle.getMessage(OutDegreeRangeBuilder.class, (String)"OutDegreeRangeBuilder.name");
        }

        private void refreshRange() {
            if (this.range == null) {
                this.range = new Range(this.min, this.max);
            } else {
                this.range.trimBounds(this.min, this.max);
            }
        }

        public boolean init(Graph graph) {
            if (!(graph instanceof DirectedGraph)) {
                return false;
            }
            if (this.range == null) {
                this.getValues();
                this.refreshRange();
            }
            this.values = new ArrayList<Integer>(((HierarchicalGraph)graph).getNodeCount());
            this.min = Integer.MAX_VALUE;
            this.max = Integer.MIN_VALUE;
            return true;
        }

        public boolean evaluate(Graph graph, Node node) {
            int degree = ((HierarchicalDirectedGraph)graph).getTotalOutDegree(node);
            this.min = Math.min(this.min, degree);
            this.max = Math.max(this.max, degree);
            this.values.add(new Integer(degree));
            return this.range.isInRange(degree);
        }

        public void finish() {
            this.refreshRange();
        }

        public Object[] getValues() {
            if (this.values == null) {
                GraphModel gm = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
                HierarchicalDirectedGraph graph = gm.getHierarchicalDirectedGraph();
                Object[] degrees = new Integer[graph.getNodeCount()];
                int i = 0;
                this.min = Integer.MAX_VALUE;
                this.max = Integer.MIN_VALUE;
                for (Node n : graph.getNodes()) {
                    int degree = graph.getTotalOutDegree(n);
                    this.min = Math.min(this.min, degree);
                    this.max = Math.max(this.max, degree);
                    degrees[i++] = degree;
                }
                this.refreshRange();
                return degrees;
            }
            return this.values.toArray(new Integer[0]);
        }

        public FilterProperty[] getProperties() {
            try {
                return new FilterProperty[]{FilterProperty.createProperty(this, Range.class, "range")};
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return new FilterProperty[0];
            }
        }

        public FilterProperty getRangeProperty() {
            return this.getProperties()[0];
        }

        public Object getMinimum() {
            return this.min;
        }

        public Object getMaximum() {
            return this.max;
        }

        public Range getRange() {
            return this.range;
        }

        public void setRange(Range range) {
            this.range = range;
        }
    }
}

