/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.hierarchy;

import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.plugin.hierarchy.LevelUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class LevelBuilder
implements FilterBuilder {
    public Category getCategory() {
        return FilterLibrary.HIERARCHY;
    }

    public String getName() {
        return NbBundle.getMessage(LevelBuilder.class, (String)"LevelBuilder.name");
    }

    public Icon getIcon() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public LevelFilter getFilter() {
        return new LevelFilter();
    }

    public JPanel getPanel(Filter filter) {
        LevelUI ui = (LevelUI)Lookup.getDefault().lookup(LevelUI.class);
        if (ui != null) {
            return ui.getPanel((LevelFilter)filter);
        }
        return null;
    }

    public void destroy(Filter filter) {
    }

    public static class LevelFilter
    implements NodeFilter {
        private Integer level = 0;
        private int height;

        public boolean init(Graph graph) {
            HierarchicalGraph hg = (HierarchicalGraph)graph;
            this.height = hg.getHeight();
            return true;
        }

        public boolean evaluate(Graph graph, Node node) {
            HierarchicalGraph hg = (HierarchicalGraph)graph;
            return hg.getLevel(node) == this.level.intValue();
        }

        public void finish() {
        }

        public int getHeight() {
            return this.height;
        }

        public String getName() {
            return NbBundle.getMessage(LevelBuilder.class, (String)"LevelBuilder.name");
        }

        public FilterProperty[] getProperties() {
            try {
                return new FilterProperty[]{FilterProperty.createProperty(this, Integer.class, "level")};
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return new FilterProperty[0];
            }
        }

        public Integer getLevel() {
            return this.level;
        }

        public void setLevel(Integer level) {
            this.level = level;
        }
    }
}

