/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.operator;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.filters.spi.Operator;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.openide.util.NbBundle;

public class INTERSECTIONBuilder
implements FilterBuilder {
    public Category getCategory() {
        return new Category("Operator");
    }

    public String getName() {
        return NbBundle.getMessage(INTERSECTIONBuilder.class, (String)"INTERSECTIONBuilder.name");
    }

    public Icon getIcon() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(INTERSECTIONBuilder.class, (String)"INTERSECTIONBuilder.description");
    }

    public Filter getFilter() {
        return new IntersectionOperator();
    }

    public JPanel getPanel(Filter filter) {
        return null;
    }

    public void destroy(Filter filter) {
    }

    public static class IntersectionOperator
    implements Operator {
        public int getInputCount() {
            return Integer.MAX_VALUE;
        }

        public String getName() {
            return NbBundle.getMessage(INTERSECTIONBuilder.class, (String)"INTERSECTIONBuilder.name");
        }

        public FilterProperty[] getProperties() {
            return null;
        }

        public Graph filter(Graph[] graphs) {
            int i;
            HierarchicalGraph minHGraph = (HierarchicalGraph)graphs[0];
            int minElements = Integer.MAX_VALUE;
            for (int i2 = 0; i2 < graphs.length; ++i2) {
                int count = ((HierarchicalGraph)graphs[i2]).getNodeCount();
                if (count >= minElements) continue;
                minHGraph = (HierarchicalGraph)graphs[i2];
                minElements = count;
            }
            block1: for (Node n : minHGraph.getNodes().toArray()) {
                for (i = 0; i < graphs.length; ++i) {
                    if ((HierarchicalGraph)graphs[i] == minHGraph || ((HierarchicalGraph)graphs[i]).contains(n)) continue;
                    minHGraph.removeNode(n);
                    continue block1;
                }
            }
            block3: for (Edge e : minHGraph.getEdges().toArray()) {
                for (i = 0; i < graphs.length; ++i) {
                    if ((HierarchicalGraph)graphs[i] == minHGraph || ((HierarchicalGraph)graphs[i]).contains(e)) continue;
                    minHGraph.removeEdge(e);
                    continue block3;
                }
            }
            return minHGraph;
        }

        public Graph filter(Graph graph, Filter[] filters) {
            Iterator itr;
            HierarchicalGraph hgraph = (HierarchicalGraph)graph;
            ArrayList<NodeFilter> nodeFilters = new ArrayList<NodeFilter>();
            ArrayList<EdgeFilter> edgeFilters = new ArrayList<EdgeFilter>();
            for (Filter f : filters) {
                if (f instanceof NodeFilter) {
                    nodeFilters.add((NodeFilter)f);
                    continue;
                }
                if (!(f instanceof EdgeFilter)) continue;
                edgeFilters.add((EdgeFilter)f);
            }
            if (nodeFilters.size() > 0) {
                itr = nodeFilters.iterator();
                while (itr.hasNext()) {
                    NodeFilter nf = (NodeFilter)itr.next();
                    if (nf.init(hgraph)) continue;
                    itr.remove();
                }
                ArrayList<Node> nodesToRemove = new ArrayList<Node>();
                block2: for (Node n : hgraph.getNodes()) {
                    for (NodeFilter nf : nodeFilters) {
                        if (nf.evaluate(hgraph, n)) continue;
                        nodesToRemove.add(n);
                        continue block2;
                    }
                }
                for (Node n : nodesToRemove) {
                    hgraph.removeNode(n);
                }
                for (NodeFilter nf : nodeFilters) {
                    nf.finish();
                }
            }
            if (edgeFilters.size() > 0) {
                itr = edgeFilters.iterator();
                while (itr.hasNext()) {
                    EdgeFilter ef = (EdgeFilter)itr.next();
                    if (ef.init(hgraph)) continue;
                    itr.remove();
                }
                ArrayList<Edge> edgesToRemove = new ArrayList<Edge>();
                block7: for (Edge e : hgraph.getEdges()) {
                    for (EdgeFilter ef : edgeFilters) {
                        if (ef.evaluate(hgraph, e)) continue;
                        edgesToRemove.add(e);
                        continue block7;
                    }
                }
                for (Edge e : edgesToRemove) {
                    hgraph.removeEdge(e);
                }
                for (EdgeFilter ef : edgeFilters) {
                    ef.finish();
                }
            }
            return hgraph;
        }
    }
}

