/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.operator;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.plugin.operator.MASKEdgeUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.filters.spi.Operator;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class MASKBuilderEdge
implements FilterBuilder {
    public Category getCategory() {
        return new Category("Operator");
    }

    public String getName() {
        return NbBundle.getMessage(MASKBuilderEdge.class, (String)"MASKBuilderEdge.name");
    }

    public Icon getIcon() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(MASKBuilderEdge.class, (String)"MASKBuilderEdge.description");
    }

    public Filter getFilter() {
        return new MaskEdgeOperator();
    }

    public JPanel getPanel(Filter filter) {
        MASKEdgeUI ui = (MASKEdgeUI)Lookup.getDefault().lookup(MASKEdgeUI.class);
        if (ui != null) {
            return ui.getPanel((MaskEdgeOperator)filter);
        }
        return null;
    }

    public void destroy(Filter filter) {
    }

    public static class MaskEdgeOperator
    implements Operator {
        private EdgesOptions option = EdgesOptions.ANY;
        private FilterProperty[] filterProperties;

        public int getInputCount() {
            return 1;
        }

        public String getName() {
            return NbBundle.getMessage(MASKBuilderEdge.class, (String)"MASKBuilderEdge.name");
        }

        public FilterProperty[] getProperties() {
            if (this.filterProperties == null) {
                this.filterProperties = new FilterProperty[0];
                try {
                    this.filterProperties = new FilterProperty[]{FilterProperty.createProperty(this, String.class, "option")};
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return this.filterProperties;
        }

        public Graph filter(Graph[] graphs) {
            if (graphs.length > 1) {
                throw new IllegalArgumentException("Filter accepts a single graph in parameter");
            }
            HierarchicalGraph hgraph = (HierarchicalGraph)graphs[0];
            GraphView hgraphView = hgraph.getView();
            HierarchicalGraph mainHGraph = hgraph.getView().getGraphModel().getHierarchicalGraph();
            ArrayList<Edge> edgesToKeep = new ArrayList<Edge>();
            for (Edge e : mainHGraph.getEdges().toArray()) {
                Node source = e.getSource().getNodeData().getNode(hgraphView.getViewId());
                Node target = e.getTarget().getNodeData().getNode(hgraphView.getViewId());
                boolean keep = false;
                switch (this.option) {
                    case SOURCE: {
                        keep = source != null;
                        break;
                    }
                    case TARGET: {
                        keep = target != null;
                        break;
                    }
                    case BOTH: {
                        keep = source != null && target != null;
                        break;
                    }
                    case ANY: {
                        boolean bl = keep = source != null || target != null;
                    }
                }
                if (!keep) continue;
                edgesToKeep.add(e);
            }
            hgraph.clearEdges();
            for (Node n : mainHGraph.getNodes().toArray()) {
                if (n.getNodeData().getNode(hgraphView.getViewId()) != null) continue;
                hgraph.addNode(n);
            }
            for (Edge e : edgesToKeep) {
                hgraph.addEdge(e);
            }
            return hgraph;
        }

        public Graph filter(Graph graph, Filter[] filters) {
            if (filters.length > 1) {
                throw new IllegalArgumentException("Filter accepts a single filter in parameter");
            }
            HierarchicalGraph hgraph = (HierarchicalGraph)graph;
            if (filters[0] instanceof NodeFilter && ((NodeFilter)filters[0]).init(hgraph)) {
                NodeFilter filter = (NodeFilter)filters[0];
                GraphView hgraphView = hgraph.getView();
                for (Edge e : hgraph.getEdges().toArray()) {
                    Node source = e.getSource().getNodeData().getNode(hgraphView.getViewId());
                    Node target = e.getTarget().getNodeData().getNode(hgraphView.getViewId());
                    boolean remove = false;
                    switch (this.option) {
                        case SOURCE: {
                            remove = !filter.evaluate(hgraph, source);
                            break;
                        }
                        case TARGET: {
                            remove = !filter.evaluate(hgraph, target);
                            break;
                        }
                        case BOTH: {
                            remove = !filter.evaluate(hgraph, source) || !filter.evaluate(hgraph, target);
                            break;
                        }
                        case ANY: {
                            boolean bl = remove = !filter.evaluate(hgraph, source) && !filter.evaluate(hgraph, target);
                        }
                    }
                    if (!remove) continue;
                    hgraph.removeEdge(e);
                }
                filter.finish();
            }
            return hgraph;
        }

        public String getOption() {
            return this.option.toString();
        }

        public void setOption(String option) {
            this.option = EdgesOptions.valueOf(option);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EdgesOptions {
            SOURCE,
            TARGET,
            ANY,
            BOTH;

        }
    }
}

