/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.operator;

import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.Operator;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.openide.util.NbBundle;

public class NOTBuilderEdge
implements FilterBuilder {
    public Category getCategory() {
        return new Category("Operator");
    }

    public String getName() {
        return NbBundle.getMessage(NOTBuilderEdge.class, (String)"NOTBuilderEdge.name");
    }

    public Icon getIcon() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(NOTBuilderEdge.class, (String)"NOTBuilderEdge.description");
    }

    public Filter getFilter() {
        return new NotOperatorEdge();
    }

    public JPanel getPanel(Filter filter) {
        return null;
    }

    public void destroy(Filter filter) {
    }

    public static class NotOperatorEdge
    implements Operator {
        public int getInputCount() {
            return 1;
        }

        public String getName() {
            return NbBundle.getMessage(NOTBuilderEdge.class, (String)"NOTBuilderEdge.name");
        }

        public FilterProperty[] getProperties() {
            return null;
        }

        public Graph filter(Graph[] graphs) {
            if (graphs.length > 1) {
                throw new IllegalArgumentException("Not Filter accepts a single graph in parameter");
            }
            HierarchicalGraph hgraph = (HierarchicalGraph)graphs[0];
            GraphView hgraphView = hgraph.getView();
            HierarchicalGraph mainHGraph = hgraph.getView().getGraphModel().getHierarchicalGraph();
            for (Edge e : mainHGraph.getEdges().toArray()) {
                Node source = e.getSource().getNodeData().getNode(hgraphView.getViewId());
                Node target = e.getTarget().getNodeData().getNode(hgraphView.getViewId());
                if (source == null || target == null) continue;
                Edge edgeInGraph = hgraph.getEdge(source, target);
                if (edgeInGraph == null) {
                    hgraph.addEdge(e);
                    continue;
                }
                hgraph.removeEdge(edgeInGraph);
            }
            return hgraph;
        }

        public Graph filter(Graph graph, Filter[] filters) {
            if (filters.length > 1) {
                throw new IllegalArgumentException("Not Filter accepts a single filter in parameter");
            }
            HierarchicalGraph hgraph = (HierarchicalGraph)graph;
            Filter filter = filters[0];
            if (filter instanceof EdgeFilter && ((EdgeFilter)filter).init(hgraph)) {
                EdgeFilter edgeFilter = (EdgeFilter)filter;
                for (Edge e : hgraph.getEdgesAndMetaEdges().toArray()) {
                    if (!edgeFilter.evaluate(hgraph, e)) continue;
                    hgraph.removeEdge(e);
                }
                edgeFilter.finish();
            }
            return hgraph;
        }
    }
}

