/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.operator;

import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.filters.spi.Operator;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.openide.util.NbBundle;

public class NOTBuilderNode
implements FilterBuilder {
    public Category getCategory() {
        return new Category("Operator");
    }

    public String getName() {
        return NbBundle.getMessage(NOTBuilderNode.class, (String)"NOTBuilderNode.name");
    }

    public Icon getIcon() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(NOTBuilderNode.class, (String)"NOTBuilderNode.description");
    }

    public Filter getFilter() {
        return new NOTOperatorNode();
    }

    public JPanel getPanel(Filter filter) {
        return null;
    }

    public void destroy(Filter filter) {
    }

    public static class NOTOperatorNode
    implements Operator {
        public int getInputCount() {
            return 1;
        }

        public String getName() {
            return NbBundle.getMessage(NOTBuilderNode.class, (String)"NOTBuilderNode.name");
        }

        public FilterProperty[] getProperties() {
            return null;
        }

        public Graph filter(Graph[] graphs) {
            if (graphs.length > 1) {
                throw new IllegalArgumentException("Not Filter accepts a single graph in parameter");
            }
            HierarchicalGraph hgraph = (HierarchicalGraph)graphs[0];
            GraphView hgraphView = hgraph.getView();
            HierarchicalGraph mainHGraph = hgraph.getView().getGraphModel().getHierarchicalGraph();
            for (Node n : mainHGraph.getNodes().toArray()) {
                if (n.getNodeData().getNode(hgraphView.getViewId()) == null) {
                    hgraph.addNode(n);
                    continue;
                }
                hgraph.removeNode(n);
            }
            for (Node n : hgraph.getNodes().toArray()) {
                Edge[] edges;
                Node mainNode = n.getNodeData().getNode(mainHGraph.getView().getViewId());
                for (Edge e : edges = mainHGraph.getEdgesAndMetaEdges(mainNode).toArray()) {
                    if (e.getSource().getNodeData().getNode(hgraphView.getViewId()) == null || e.getTarget().getNodeData().getNode(hgraphView.getViewId()) == null) continue;
                    hgraph.addEdge(e);
                }
            }
            return hgraph;
        }

        public Graph filter(Graph graph, Filter[] filters) {
            if (filters.length > 1) {
                throw new IllegalArgumentException("Not Filter accepts a single filter in parameter");
            }
            HierarchicalGraph hgraph = (HierarchicalGraph)graph;
            Filter filter = filters[0];
            if (filter instanceof NodeFilter && ((NodeFilter)filter).init(hgraph)) {
                NodeFilter nodeFilter = (NodeFilter)filter;
                for (Node n : hgraph.getNodes().toArray()) {
                    if (!nodeFilter.evaluate(hgraph, n)) continue;
                    hgraph.removeNode(n);
                }
                nodeFilter.finish();
            }
            return hgraph;
        }
    }
}

