/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.operator;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.filters.spi.Operator;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.openide.util.NbBundle;

public class UNIONBuilder
implements FilterBuilder {
    public Category getCategory() {
        return new Category("Operator");
    }

    public String getName() {
        return NbBundle.getMessage(UNIONBuilder.class, (String)"UNIONBuilder.name");
    }

    public Icon getIcon() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(UNIONBuilder.class, (String)"UNIONBuilder.description");
    }

    public Filter getFilter() {
        return new UnionOperator();
    }

    public JPanel getPanel(Filter filter) {
        return null;
    }

    public void destroy(Filter filter) {
    }

    public static class UnionOperator
    implements Operator {
        public int getInputCount() {
            return Integer.MAX_VALUE;
        }

        public String getName() {
            return NbBundle.getMessage(UNIONBuilder.class, (String)"UNIONBuilder.name");
        }

        public FilterProperty[] getProperties() {
            return null;
        }

        public Graph filter(Graph[] graphs) {
            int i;
            HierarchicalGraph maxHGraph = (HierarchicalGraph)graphs[0];
            int maxElements = 0;
            for (i = 0; i < graphs.length; ++i) {
                int count = ((HierarchicalGraph)graphs[i]).getNodeCount();
                if (count <= maxElements) continue;
                maxHGraph = (HierarchicalGraph)graphs[i];
                maxElements = count;
            }
            for (i = 0; i < graphs.length; ++i) {
                if ((HierarchicalGraph)graphs[i] == maxHGraph) continue;
                for (Node n : ((HierarchicalGraph)graphs[i]).getNodes().toArray()) {
                    maxHGraph.addNode(n);
                }
                for (Edge e : ((HierarchicalGraph)graphs[i]).getEdgesAndMetaEdges().toArray()) {
                    maxHGraph.addEdge(e);
                }
            }
            return maxHGraph;
        }

        public Graph filter(Graph graph, Filter[] filters) {
            Iterator itr;
            HierarchicalGraph hgraph = (HierarchicalGraph)graph;
            ArrayList<NodeFilter> nodeFilters = new ArrayList<NodeFilter>();
            ArrayList<EdgeFilter> edgeFilters = new ArrayList<EdgeFilter>();
            for (Filter f : filters) {
                if (f instanceof NodeFilter) {
                    nodeFilters.add((NodeFilter)f);
                    continue;
                }
                if (!(f instanceof EdgeFilter)) continue;
                edgeFilters.add((EdgeFilter)f);
            }
            if (nodeFilters.size() > 0) {
                itr = nodeFilters.iterator();
                while (itr.hasNext()) {
                    NodeFilter nf = (NodeFilter)itr.next();
                    if (nf.init(hgraph)) continue;
                    itr.remove();
                }
                ArrayList<Node> nodesToRemove = new ArrayList<Node>();
                for (Node n : hgraph.getNodes()) {
                    boolean remove = true;
                    for (NodeFilter nf : nodeFilters) {
                        if (!nf.evaluate(hgraph, n)) continue;
                        remove = false;
                    }
                    if (!remove) continue;
                    nodesToRemove.add(n);
                }
                for (Node n : nodesToRemove) {
                    hgraph.removeNode(n);
                }
                for (NodeFilter nf : nodeFilters) {
                    nf.finish();
                }
            }
            if (edgeFilters.size() > 0) {
                itr = edgeFilters.iterator();
                while (itr.hasNext()) {
                    EdgeFilter ef = (EdgeFilter)itr.next();
                    if (ef.init(hgraph)) continue;
                    itr.remove();
                }
                ArrayList<Edge> edgesToRemove = new ArrayList<Edge>();
                for (Edge e : hgraph.getEdgesAndMetaEdges()) {
                    boolean remove = true;
                    for (EdgeFilter ef : edgeFilters) {
                        if (!ef.evaluate(hgraph, e)) continue;
                        remove = false;
                    }
                    if (!remove) continue;
                    edgesToRemove.add(e);
                }
                for (Edge e : edgesToRemove) {
                    hgraph.removeEdge(e);
                }
                for (EdgeFilter ef : edgeFilters) {
                    ef.finish();
                }
            }
            return hgraph;
        }
    }
}

