/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.partition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeUtils;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.plugin.partition.PartitionUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.partition.api.EdgePartition;
import org.gephi.partition.api.NodePartition;
import org.gephi.partition.api.Part;
import org.gephi.partition.api.Partition;
import org.gephi.partition.api.PartitionController;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PartitionBuilder
implements CategoryBuilder {
    private static final Category PARTITION = new Category(NbBundle.getMessage(PartitionBuilder.class, (String)"PartitionBuilder.name"), null, FilterLibrary.ATTRIBUTES);

    public Category getCategory() {
        return PARTITION;
    }

    public FilterBuilder[] getBuilders() {
        ArrayList<PartitionFilterBuilder> builders = new ArrayList<PartitionFilterBuilder>();
        PartitionController pc = (PartitionController)Lookup.getDefault().lookup(PartitionController.class);
        if (pc.getModel() != null) {
            PartitionFilterBuilder builder;
            pc.refreshPartitions();
            NodePartition[] nodePartitions = pc.getModel().getNodePartitions();
            EdgePartition[] edgePartitions = pc.getModel().getEdgePartitions();
            for (NodePartition nodePartition : nodePartitions) {
                builder = new PartitionFilterBuilder(nodePartition.getColumn(), nodePartition);
                builders.add(builder);
            }
            for (Partition<Node> partition : edgePartitions) {
                builder = new PartitionFilterBuilder(partition.getColumn(), (EdgePartition)partition);
                builders.add(builder);
            }
        }
        return builders.toArray(new FilterBuilder[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PartitionFilter
    implements Filter {
        private Partition partition;
        private FilterProperty[] filterProperties;
        private List<Part> parts;

        public PartitionFilter(Partition partition) {
            this.partition = partition;
            this.parts = new ArrayList<Part>();
        }

        @Override
        public String getName() {
            return NbBundle.getMessage(PartitionBuilder.class, (String)"PartitionBuilder.name");
        }

        public boolean init(Graph graph) {
            HierarchicalGraph hg = graph.getGraphModel().getHierarchicalGraphVisible();
            this.partition = ((PartitionController)Lookup.getDefault().lookup(PartitionController.class)).buildPartition(this.partition.getColumn(), hg);
            return true;
        }

        public boolean evaluate(Graph graph, Node node) {
            Object value = node.getNodeData().getAttributes().getValue(this.partition.getColumn().getIndex());
            int size = this.parts.size();
            for (int i = 0; i < size; ++i) {
                Object obj = this.parts.get(i).getValue();
                if (obj == null && value == null) {
                    return true;
                }
                if (obj == null || value == null || !obj.equals(value)) continue;
                return true;
            }
            return false;
        }

        public boolean evaluate(Graph graph, Edge edge) {
            Object value = edge.getEdgeData().getAttributes().getValue(this.partition.getColumn().getIndex());
            int size = this.parts.size();
            for (int i = 0; i < size; ++i) {
                Object obj = this.parts.get(i).getValue();
                if (obj == null && value == null) {
                    return true;
                }
                if (obj == null || value == null || !obj.equals(value)) continue;
                return true;
            }
            return false;
        }

        public void finish() {
        }

        public void addPart(Part part) {
            if (!this.parts.contains(part)) {
                ArrayList<Part> newParts = new ArrayList<Part>(this.parts.size() + 1);
                newParts.addAll(this.parts);
                newParts.add(part);
                this.getProperties()[1].setValue(newParts);
            }
        }

        public void removePart(Part part) {
            ArrayList<Part> newParts = new ArrayList<Part>(this.parts);
            if (newParts.remove(part)) {
                this.getProperties()[1].setValue(newParts);
            }
        }

        public void unselectAll() {
            this.getProperties()[1].setValue(new ArrayList());
        }

        public void selectAll() {
            this.getProperties()[1].setValue(Arrays.asList(this.partition.getParts()));
        }

        @Override
        public FilterProperty[] getProperties() {
            if (this.filterProperties == null) {
                this.filterProperties = new FilterProperty[0];
                try {
                    this.filterProperties = new FilterProperty[]{FilterProperty.createProperty(this, AttributeColumn.class, "column"), FilterProperty.createProperty(this, List.class, "parts")};
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return this.filterProperties;
        }

        public Partition getCurrentPartition() {
            if (this.partition.getPartsCount() == 0) {
                GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
                this.partition = ((PartitionController)Lookup.getDefault().lookup(PartitionController.class)).buildPartition(this.partition.getColumn(), graphModel.getHierarchicalGraphVisible());
            }
            return this.partition;
        }

        public Partition getPartition() {
            return this.partition;
        }

        public List<Part> getParts() {
            return this.parts;
        }

        public AttributeColumn getColumn() {
            return this.partition.getColumn();
        }

        public void setColumn(AttributeColumn column) {
        }

        public void setParts(List<Part> parts) {
            this.parts = parts;
        }

        public void setPartition(Partition partition) {
            this.partition = partition;
        }
    }

    public static class EdgePartitionFilter
    extends PartitionFilter
    implements EdgeFilter {
        public EdgePartitionFilter(Partition partition) {
            super(partition);
        }
    }

    public static class NodePartitionFilter
    extends PartitionFilter
    implements NodeFilter {
        public NodePartitionFilter(Partition partition) {
            super(partition);
        }
    }

    private static class PartitionFilterBuilder
    implements FilterBuilder {
        private final AttributeColumn column;
        private Partition partition;

        public PartitionFilterBuilder(AttributeColumn column, NodePartition partition) {
            this.column = column;
            this.partition = partition;
        }

        public PartitionFilterBuilder(AttributeColumn column, EdgePartition partition) {
            this.column = column;
            this.partition = partition;
        }

        public Category getCategory() {
            return PARTITION;
        }

        public String getName() {
            return this.column.getTitle() + " (" + (this.partition instanceof NodePartition ? "Node" : "Edge") + ")";
        }

        public Icon getIcon() {
            return null;
        }

        public String getDescription() {
            return NbBundle.getMessage(PartitionBuilder.class, (String)"PartitionBuilder.description");
        }

        public PartitionFilter getFilter() {
            if (AttributeUtils.getDefault().isNodeColumn(this.column)) {
                return new NodePartitionFilter(this.partition);
            }
            return new EdgePartitionFilter(this.partition);
        }

        public JPanel getPanel(Filter filter) {
            PartitionUI ui = (PartitionUI)Lookup.getDefault().lookup(PartitionUI.class);
            if (ui != null) {
                return ui.getPanel((PartitionFilter)filter);
            }
            return null;
        }

        public void destroy(Filter filter) {
        }
    }
}

