/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.partition;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeUtils;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.api.Range;
import org.gephi.filters.plugin.RangeFilter;
import org.gephi.filters.plugin.graph.RangeUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.partition.api.EdgePartition;
import org.gephi.partition.api.NodePartition;
import org.gephi.partition.api.Part;
import org.gephi.partition.api.Partition;
import org.gephi.partition.api.PartitionController;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PartitionCountBuilder
implements CategoryBuilder {
    private static final Category PARTITION_COUNT = new Category(NbBundle.getMessage(PartitionCountBuilder.class, (String)"PartitionCountBuilder.name"), null, FilterLibrary.ATTRIBUTES);

    public Category getCategory() {
        return PARTITION_COUNT;
    }

    public FilterBuilder[] getBuilders() {
        ArrayList<PartitionCountFilterBuilder> builders = new ArrayList<PartitionCountFilterBuilder>();
        PartitionController pc = (PartitionController)Lookup.getDefault().lookup(PartitionController.class);
        if (pc.getModel() != null) {
            PartitionCountFilterBuilder builder;
            pc.refreshPartitions();
            NodePartition[] nodePartitions = pc.getModel().getNodePartitions();
            EdgePartition[] edgePartitions = pc.getModel().getEdgePartitions();
            for (NodePartition nodePartition : nodePartitions) {
                builder = new PartitionCountFilterBuilder(nodePartition.getColumn(), nodePartition);
                builders.add(builder);
            }
            for (Partition<Node> partition : edgePartitions) {
                builder = new PartitionCountFilterBuilder(partition.getColumn(), (EdgePartition)partition);
                builders.add(builder);
            }
        }
        return builders.toArray(new FilterBuilder[0]);
    }

    public static class PartitionCountFilter
    implements Filter,
    RangeFilter {
        private Partition partition;
        private FilterProperty[] filterProperties;
        private Integer min = 0;
        private Integer max = 0;
        private Range range = new Range(0, 0);
        private Integer[] values;

        public PartitionCountFilter(Partition partition) {
            this.partition = partition;
        }

        private void refreshRange() {
            Integer lowerBound = this.range.getLowerInteger();
            Integer upperBound = this.range.getUpperInteger();
            if (this.min > lowerBound || this.max < lowerBound || lowerBound.equals(upperBound)) {
                lowerBound = this.min;
            }
            if (this.min > upperBound || this.max < upperBound || lowerBound.equals(upperBound)) {
                upperBound = this.max;
            }
            this.range = new Range(lowerBound, upperBound);
        }

        public boolean init(Graph graph) {
            HierarchicalGraph hg = graph.getGraphModel().getHierarchicalGraphVisible();
            this.partition = ((PartitionController)Lookup.getDefault().lookup(PartitionController.class)).buildPartition(this.partition.getColumn(), hg);
            return true;
        }

        public boolean evaluate(Graph graph, Node node) {
            Part<Node> p = this.partition.getPart(node);
            if (p != null) {
                int partCount = p.getObjects().length;
                return this.range.isInRange(partCount);
            }
            return false;
        }

        public boolean evaluate(Graph graph, Edge edge) {
            Part<Edge> p = this.partition.getPart(edge);
            if (p != null) {
                int partCount = p.getObjects().length;
                return this.range.isInRange(partCount);
            }
            return false;
        }

        public void finish() {
            this.refreshRange();
        }

        public String getName() {
            return NbBundle.getMessage(PartitionCountBuilder.class, (String)"PartitionCountBuilder.name");
        }

        public FilterProperty[] getProperties() {
            if (this.filterProperties == null) {
                this.filterProperties = new FilterProperty[0];
                try {
                    this.filterProperties = new FilterProperty[]{FilterProperty.createProperty(this, AttributeColumn.class, "column"), FilterProperty.createProperty(this, Range.class, "range")};
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return this.filterProperties;
        }

        public FilterProperty getRangeProperty() {
            return this.filterProperties[1];
        }

        public Object[] getValues() {
            if (this.values == null) {
                this.min = Integer.MAX_VALUE;
                this.max = Integer.MIN_VALUE;
                if (this.partition.getPartsCount() == 0) {
                    GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
                    this.partition = ((PartitionController)Lookup.getDefault().lookup(PartitionController.class)).buildPartition(this.partition.getColumn(), graphModel.getHierarchicalGraphVisible());
                }
                this.values = new Integer[this.partition.getPartsCount()];
                Part<Element>[] parts = this.partition.getParts();
                for (int i = 0; i < parts.length; ++i) {
                    int partCount = parts[i].getObjects().length;
                    this.min = Math.min(this.min, partCount);
                    this.max = Math.max(this.max, partCount);
                    this.values[i] = partCount;
                }
                this.refreshRange();
            }
            return this.values;
        }

        public Object getMinimum() {
            return this.min;
        }

        public Object getMaximum() {
            return this.max;
        }

        public Range getRange() {
            return this.range;
        }

        public void setRange(Range range) {
            this.range = range;
        }

        public AttributeColumn getColumn() {
            return this.partition.getColumn();
        }

        public void setColumn(AttributeColumn column) {
        }
    }

    public static class EdgePartitionCountFilter
    extends PartitionCountFilter
    implements EdgeFilter {
        public EdgePartitionCountFilter(Partition partition) {
            super(partition);
        }
    }

    public static class NodePartitionCountFilter
    extends PartitionCountFilter
    implements NodeFilter {
        public NodePartitionCountFilter(Partition partition) {
            super(partition);
        }
    }

    private static class PartitionCountFilterBuilder
    implements FilterBuilder {
        private final AttributeColumn column;
        private Partition partition;

        public PartitionCountFilterBuilder(AttributeColumn column, NodePartition partition) {
            this.column = column;
            this.partition = partition;
        }

        public PartitionCountFilterBuilder(AttributeColumn column, EdgePartition partition) {
            this.column = column;
            this.partition = partition;
        }

        public Category getCategory() {
            return PARTITION_COUNT;
        }

        public String getName() {
            return this.column.getTitle() + " (" + (this.partition instanceof NodePartition ? "Node" : "Edge") + ")";
        }

        public Icon getIcon() {
            return null;
        }

        public String getDescription() {
            return NbBundle.getMessage(PartitionCountBuilder.class, (String)"PartitionCountBuilder.description");
        }

        public PartitionCountFilter getFilter() {
            if (AttributeUtils.getDefault().isNodeColumn(this.column)) {
                return new NodePartitionCountFilter(this.partition);
            }
            return new EdgePartitionCountFilter(this.partition);
        }

        public JPanel getPanel(Filter filter) {
            RangeUI ui = (RangeUI)Lookup.getDefault().lookup(RangeUI.class);
            if (ui != null) {
                return ui.getPanel((PartitionCountFilter)filter);
            }
            return null;
        }

        public void destroy(Filter filter) {
        }
    }
}

