/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.spi;

import java.beans.PropertyEditor;
import org.gephi.filters.api.PropertyExecutor;
import org.gephi.filters.spi.Filter;
import org.openide.nodes.PropertySupport;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterProperty {
    protected PropertySupport.Reflection property;
    protected Filter filter;
    protected PropertyExecutor propertyExecutor;

    FilterProperty(Filter filter) {
        this.filter = filter;
        this.propertyExecutor = (PropertyExecutor)Lookup.getDefault().lookup(PropertyExecutor.class);
    }

    public String getName() {
        return this.property.getDisplayName();
    }

    public Object getValue() {
        try {
            return this.property.getValue();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void setValue(Object value) {
        if (this.propertyExecutor != null) {
            this.propertyExecutor.setValue(this, value, new PropertyExecutor.Callback(){

                public void setValue(Object value) {
                    try {
                        FilterProperty.this.property.setValue(value);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            try {
                this.property.setValue(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public PropertyEditor getPropertyEditor() {
        return this.property.getPropertyEditor();
    }

    public void setPropertyEditorClass(Class<? extends PropertyEditor> clazz) {
        this.property.setPropertyEditorClass(clazz);
    }

    public Class getValueType() {
        return this.property.getValueType();
    }

    public Filter getFilter() {
        return this.filter;
    }

    public static FilterProperty createProperty(Filter filter, Class valueType, String propertyName, String getMethod, String setMethod) throws NoSuchMethodException {
        FilterProperty filterProperty = new FilterProperty(filter);
        PropertySupport.Reflection property = new PropertySupport.Reflection((Object)filter, valueType, getMethod, setMethod);
        property.setName(propertyName);
        filterProperty.property = property;
        return filterProperty;
    }

    public static FilterProperty createProperty(Filter filter, Class valueType, String fieldName) throws NoSuchMethodException {
        if (valueType == Boolean.class) {
            valueType = Boolean.TYPE;
        }
        FilterProperty filterProperty = new FilterProperty(filter);
        PropertySupport.Reflection property = new PropertySupport.Reflection((Object)filter, valueType, fieldName);
        property.setName(fieldName);
        filterProperty.property = property;
        return filterProperty;
    }
}

